/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.driver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.api.common.DriverProgram;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.driver.DriverSourceFunction;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

public class DriverEntry
implements DriverProgram {
    public static final String BLOB_TYPE_SEPARATOR = "#";
    public static final String BLOB_TYPE_JARFILE = "jarFile";
    public static final String BLOB_TYPE_EXTERNAL_FILE = "externalFile";
    public static final String BLOB_TYPE_CLASSPATH = "classPath";
    public static final String BLOB_TYPE_LIB_JARS = "libJars";
    private static PackagedProgram packagedProgram;
    private static Configuration configuration;
    private static String driveName;

    public void setParameter(Object parameter) {
        if (parameter == null || parameter instanceof PackagedProgram) {
            packagedProgram = (PackagedProgram)parameter;
        }
    }

    public void setConfiguration(Configuration configuration) {
        DriverEntry.configuration = configuration;
    }

    public static void main(String[] args) throws Exception {
        driveName = "FlinkDriverJob_" + System.currentTimeMillis();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DriverEntry.manageJobBlobs(env, packagedProgram.getAllLibraries(), BLOB_TYPE_JARFILE);
        DriverEntry.manageJobBlobs(env, packagedProgram.getFiles(), BLOB_TYPE_EXTERNAL_FILE);
        DriverEntry.manageJobBlobs(env, packagedProgram.getClasspaths(), BLOB_TYPE_CLASSPATH);
        DriverEntry.manageJobBlobs(env, packagedProgram.getLibjars(), BLOB_TYPE_LIB_JARS);
        if (packagedProgram.getDriverArgs() != null) {
            ResourceSpec resourceSpec = DriverEntry.buildDriverResourceSpec(packagedProgram.getDriverArgs());
            env.setDefaultResources(resourceSpec);
        }
        env.setRestartStrategy(RestartStrategies.noRestart());
        env.getCustomConfiguration().setInteger("flink.driver.manage.priority", 0);
        env.addSource(DriverEntry.createSourceFunction()).addSink(new SinkFunction<Byte>(){

            @Override
            public void invoke(Byte value, SinkFunction.Context context) throws Exception {
            }
        });
        env.submit(driveName);
    }

    private static SourceFunction<Byte> createSourceFunction() {
        DriverSourceFunction driverSourceFunction = new DriverSourceFunction(driveName, packagedProgram.getDriverClass(), packagedProgram.getArguments(), packagedProgram.getAllLibraries(), packagedProgram.getClasspaths(), DriverSourceFunction.transURItoURL(packagedProgram.getLibjars()), DriverSourceFunction.transURItoURL(packagedProgram.getFiles()), configuration);
        return driverSourceFunction;
    }

    private static void manageJobBlobs(StreamExecutionEnvironment env, List<? extends Object> jobBlobs, String suffix) {
        for (Object object : jobBlobs) {
            URL url = null;
            if (object instanceof URI) {
                try {
                    url = ((URI)object).toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (object instanceof URL) {
                url = (URL)object;
            }
            if (url == null) continue;
            String fileName = FilenameUtils.getName((String)url.getPath());
            env.registerCachedFile(url.toString(), suffix + BLOB_TYPE_SEPARATOR + fileName);
        }
    }

    private static ResourceSpec buildDriverResourceSpec(Map<String, Object> args) {
        ResourceSpec.Builder builder = ResourceSpec.newBuilder();
        if (args.containsKey("DRIVER_CPU_CORE")) {
            builder.setCpuCores(((Double)args.get("DRIVER_CPU_CORE")).doubleValue());
        }
        if (args.containsKey("DRIVER_HEAP_MEMORY")) {
            builder.setHeapMemoryInMB(((Integer)args.get("DRIVER_HEAP_MEMORY")).intValue());
        }
        if (args.containsKey("DRIVER_DIRECT_MEMORY")) {
            builder.setDirectMemoryInMB(((Integer)args.get("DRIVER_DIRECT_MEMORY")).intValue());
        }
        if (args.containsKey("DRIVER_NATIVE_MEMORY")) {
            builder.setNativeMemoryInMB(((Integer)args.get("DRIVER_NATIVE_MEMORY")).intValue());
        }
        return builder.build();
    }
}

