/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.utils;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class IOUtils {
    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? IOUtils.toString(new InputStreamReader(input)) : IOUtils.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int totalBytes = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            list.add(line);
        }
        return list;
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source, String target) throws IOException {
        File sf = new File(source);
        if (!sf.exists()) {
            throw new IllegalArgumentException("source file does not exist.");
        }
        File tf = new File(target);
        tf.getParentFile().mkdirs();
        if (!tf.exists() && !tf.createNewFile()) {
            throw new RuntimeException("failed to create target file.");
        }
        AbstractInterruptibleChannel sc = null;
        FileChannel tc = null;
        try {
            tc = new FileOutputStream(tf).getChannel();
            sc = new FileInputStream(sf).getChannel();
            ((FileChannel)sc).transferTo(0L, ((FileChannel)sc).size(), tc);
        }
        finally {
            if (null != sc) {
                sc.close();
            }
            if (null != tc) {
                tc.close();
            }
        }
    }

    public static void delete(File fileOrDir) throws IOException {
        if (fileOrDir == null) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            IOUtils.cleanDirectory(fileOrDir);
        }
        fileOrDir.delete();
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                IOUtils.delete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(encoding));
        }
        finally {
            if (null != os) {
                ((OutputStream)os).close();
            }
        }
    }

    public static boolean isGzipStream(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return 35615 == ((bytes[1] << 8 | bytes[0]) & 0xFFFF);
    }

    private static int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b < -1 || b > 255) {
            throw new IOException(".read() returned value out of range -1..255: " + b);
        }
        return b;
    }

    public static byte[] tryDecompress(byte[] raw) throws Exception {
        if (!IOUtils.isGzipStream(raw)) {
            return raw;
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(raw));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(gis, out);
        return out.toByteArray();
    }

    public static File makeSureParentDirExists(String path) {
        File file = new File(path);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new IllegalStateException("failed to create cache dir: " + VIPClient.getCacheDir());
        }
        return file;
    }

    public static File createFileIfNessary(String filePath) throws Exception {
        File file = new File(filePath);
        if (!(file.exists() || file.createNewFile() || file.exists())) {
            throw new IllegalStateException("failed to create cache file");
        }
        return file;
    }
}

