/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.beat;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.beat.BeatInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BeatReactor
implements Runnable {
    private static BeatReactor beatReactor = null;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("VIPSERVER-BEAT-SENDER");
            return thread;
        }
    });
    private long clientBeatInterval = 10000L;
    private volatile boolean enableBeat = true;

    public static BeatReactor getBeatReactor() {
        if (beatReactor == null) {
            beatReactor = new BeatReactor();
        }
        return beatReactor;
    }

    public static void init() {
        beatReactor = new BeatReactor();
    }

    private BeatReactor() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    for (Map.Entry<String, BeatInfo> entry : VIPClient.dom2Beat.entrySet()) {
                        BeatInfo beatInfo = entry.getValue();
                        this.executorService.schedule(new BeatTask(beatInfo), 0L, TimeUnit.MILLISECONDS);
                        VIPClient.LOG.info("BEAT", "send beat to server: ", beatInfo.toString());
                    }
                    TimeUnit.MILLISECONDS.sleep(this.clientBeatInterval);
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("CLIENT-BEAT", "Exception while scheduling beat.", e);
                continue;
            }
            break;
        }
    }

    class BeatTask
    implements Runnable {
        BeatInfo beatInfo;

        public BeatTask(BeatInfo beatInfo) {
            this.beatInfo = beatInfo;
        }

        @Override
        public void run() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("beat", JSON.toJSONString(this.beatInfo));
            params.put("dom", this.beatInfo.getDom());
            params.put("tid", this.beatInfo.getTenant());
            params.put("ak", this.beatInfo.getAk());
            try {
                String result = VIPServerProxy.callAllSites("clientBeat", params);
                JSONObject jsonObject = JSON.parseObject(result);
                if (jsonObject != null) {
                    BeatReactor.this.clientBeatInterval = jsonObject.getLong("clientBeatInterval");
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("CLIENT-BEAT", "failed to send beat: " + JSON.toJSONString(this.beatInfo), e);
            }
        }
    }
}

