/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.kit;

import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.google.common.collect.Lists;
import java.util.Objects;

public class WorkflowKit {
    public static Long calculateNextTriggerAt(Integer triggerType, String triggerInterval, Long time) {
        WorkflowKit.checkExecuteInterval(triggerType, triggerInterval);
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)triggerType);
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(triggerInterval);
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    public static void checkExecuteInterval(Integer triggerType, String triggerInterval) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(triggerType) ? Integer.parseInt(triggerInterval) < 10 : Objects.equals(triggerType, WaitStrategies.WaitStrategyEnum.CRON.getType()) && CronUtils.getExecuteInterval((String)triggerInterval) < 10000L) {
            throw new SnailJobServerException("Trigger interval must not be less than 10");
        }
    }
}

