/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.JobExecutorRequest;
import com.aizuda.snailjob.server.common.handler.GetHttpRequestHandler;
import com.aizuda.snailjob.server.job.task.support.handler.DistributedLockHandler;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.JobExecutor;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RegisterJobExecutorsHttpRequestHandler
extends GetHttpRequestHandler {
    private DistributedLockHandler distributedLockHandler;
    private static final String KEY = "register_{0}_{1}";
    private final AccessTemplate accessTemplate;

    public boolean supports(String path) {
        return "/register/job/executors".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Beat register job executors content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object arg = retryRequest.getArgs()[0];
        if (arg == null) {
            return new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), "Beat register job executors arg is null", (Object)Boolean.FALSE, retryRequest.getReqId());
        }
        String groupName = headers.get(HeadersEnum.GROUP_NAME.getKey());
        String namespace = headers.get(HeadersEnum.NAMESPACE.getKey());
        String executorType = headers.get(HeadersEnum.EXECUTOR_TYPE.getKey());
        String lockName = RegisterJobExecutorsHttpRequestHandler.processLockName(MessageFormat.format(KEY, groupName, namespace));
        this.distributedLockHandler.lockWithDisposableAndRetry(() -> {
            List executors = JsonUtil.parseList((String)JsonUtil.toJsonString((Object)arg), JobExecutorRequest.class);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(JobExecutor::getGroupName, (Object)groupName)).eq(JobExecutor::getNamespaceId, (Object)namespace);
            List dbExecutors = this.accessTemplate.getJobExecutorAccess().list(queryWrapper);
            List<String> dbExecutorsList = dbExecutors.stream().map(JobExecutor::getExecutorInfo).toList();
            List<JobExecutorRequest> toAddExecutors = executors.stream().filter(e -> !dbExecutorsList.contains(e.getExecutorInfo())).toList();
            if (toAddExecutors.isEmpty()) {
                SnailJobLog.LOCAL.warn("Beat register job executors toAddExecutors is empty", new Object[0]);
                return;
            }
            List<JobExecutor> jobExecutorList = toAddExecutors.stream().map(e -> {
                JobExecutor jobExecutor = new JobExecutor();
                jobExecutor.setGroupName(groupName);
                jobExecutor.setNamespaceId(namespace);
                jobExecutor.setExecutorType(executorType);
                jobExecutor.setExecutorInfo(e.getExecutorInfo());
                return jobExecutor;
            }).toList();
            this.accessTemplate.getJobExecutorAccess().insertBatch(jobExecutorList);
        }, lockName, Duration.ofSeconds(2L), Duration.ofSeconds(2L), 3);
        return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "Batch Register Job Executors Processed Successfully", (Object)Boolean.TRUE, retryRequest.getReqId());
    }

    public static String processLockName(String input) {
        if (input.length() <= 64) {
            return input;
        }
        HashFunction hashFunction = Hashing.sha256();
        return hashFunction.hashBytes(input.getBytes(StandardCharsets.UTF_8)).toString();
    }

    @Generated
    public RegisterJobExecutorsHttpRequestHandler(DistributedLockHandler distributedLockHandler, AccessTemplate accessTemplate) {
        this.distributedLockHandler = distributedLockHandler;
        this.accessTemplate = accessTemplate;
    }
}

