/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BroadcastClientCallbackHandler
extends AbstractClientCallbackHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BroadcastClientCallbackHandler.class);
    private final InstanceManager instanceManager;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.BROADCAST;
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        Set nodes = StreamUtils.toSet((Collection)this.instanceManager.getInstanceALiveInfoSet(context.getNamespaceId(), context.getGroupName()), InstanceLiveInfo::getNodeInfo);
        if (CollUtil.isEmpty((Collection)nodes)) {
            log.error("No executable client information. Job ID:[{}]", (Object)context.getJobId());
            return null;
        }
        JobTask jobTask = context.getJobTask();
        String clientInfo = jobTask.getClientInfo();
        String clientId = ClientInfoUtils.clientId((String)clientInfo);
        InstanceKey instanceKey = InstanceKey.builder().groupName(context.getGroupName()).namespaceId(context.getNamespaceId()).hostId(clientId).build();
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(instanceKey);
        if (Objects.isNull(instanceLiveInfo)) {
            List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId()));
            Set remoteClientIdSet = StreamUtils.toSet((Collection)nodes, RegisterNodeInfo::getHostId);
            Sets.SetView diff = Sets.difference((Set)remoteClientIdSet, BroadcastClientCallbackHandler.getClientIdList(jobTasks));
            String newClientId = (String)CollUtil.getFirst(diff.stream().iterator());
            instanceKey = InstanceKey.builder().groupName(context.getGroupName()).namespaceId(context.getNamespaceId()).hostId(newClientId).build();
            InstanceLiveInfo newInstanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(instanceKey);
            if (Objects.isNull(newInstanceLiveInfo)) {
                return clientInfo;
            }
            return ClientInfoUtils.generate((RegisterNodeInfo)newInstanceLiveInfo.getNodeInfo());
        }
        return clientInfo;
    }

    private static Set<String> getClientIdList(List<JobTask> jobTasks) {
        return StreamUtils.toSet(jobTasks, jobTask -> ClientInfoUtils.clientId((String)jobTask.getClientInfo()));
    }

    @Generated
    public BroadcastClientCallbackHandler(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

