/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.cache;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheConsumerGroup
implements Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheConsumerGroup.class);
    private static Cache<String, Set<String>> CACHE;

    public static ConcurrentMap<String, Set<String>> getAllConsumerGroupName() {
        return CACHE.asMap();
    }

    public static synchronized void addOrUpdate(String groupName, String namespaceId) {
        Set namespaceIds = Optional.ofNullable((Set)CACHE.getIfPresent((Object)groupName)).orElseGet(HashSet::new);
        namespaceIds.add(namespaceId);
        CACHE.put((Object)groupName, (Object)namespaceIds);
    }

    public static void remove(String groupName) {
        SnailJobLog.LOCAL.debug("Remove consumer cache. groupName:[{}]", new Object[]{groupName});
        CACHE.invalidate((Object)groupName);
    }

    public static void clear() {
        CACHE.invalidateAll();
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("CacheRegisterTable start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("CacheRegisterTable stop", new Object[0]);
        CACHE.invalidateAll();
    }
}

