/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.starter;

import com.aizuda.snailjob.client.core.annotation.Retryable;
import com.aizuda.snailjob.client.core.intercepter.SnailRetryInterceptor;
import com.aizuda.snailjob.client.core.intercepter.SnailRetryPointcutAdvisor;
import com.aizuda.snailjob.client.core.strategy.RetryStrategy;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.StandardEnvironment;

@Configuration
@Role(value=2)
@ConditionalOnClass(value={Retryable.class})
@ComponentScan(value={"com.aizuda.snailjob.client.core", "com.aizuda.snailjob.client.common"})
@ConditionalOnProperty(prefix="snail-job", name={"enabled"}, havingValue="true")
public class SnailJobClientRetryCoreAutoConfiguration {
    @Bean
    @Role(value=2)
    public Advisor snailJobPointcutAdvisor(MethodInterceptor snailJobInterceptor) {
        return new SnailRetryPointcutAdvisor(snailJobInterceptor);
    }

    @Bean
    @Role(value=2)
    public MethodInterceptor snailJobInterceptor(StandardEnvironment standardEnvironment, @Lazy RetryStrategy localRetryStrategies) {
        Integer order = (Integer)standardEnvironment.getProperty("snail-job.aop.order", Integer.class, (Object)Integer.MIN_VALUE);
        return new SnailRetryInterceptor(order.intValue(), localRetryStrategies);
    }
}

