/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor.builtin;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.common.core.exception.SnailJobInnerExecutorException;
import com.aizuda.snailjob.common.core.util.SnailJobFileUtil;
import com.aizuda.snailjob.common.core.util.SnailJobSystemUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.dto.ExecuteResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScriptExecutor.class);
    protected static final String SH_SHELL = "/bin/sh";
    private static String WORKER_DIR;
    private static final String SCRIPT_DOWNLOAD_METHOD = "DOWNLOAD";
    private static final String SCRIPT_SCRIPT_CODE_METHOD = "SCRIPT_CODE";
    private static final String SCRIPT_LOCAL_SCRIPT_METHOD = "LOCAL_SCRIPT";

    public AbstractScriptExecutor(SnailJobProperties snailJobProperties) {
        if (Objects.isNull(snailJobProperties)) {
            log.warn("snailJobProperties is null");
        }
        WORKER_DIR = SnailFileUtils.workspace(snailJobProperties);
    }

    protected ExecuteResult process(Long jobId, ScriptParams scriptParams) {
        this.logInfo("ScriptProcessor start to process, params: {}", scriptParams);
        if (scriptParams == null) {
            this.logWarn("ScriptParams is null, please check jobParam configuration.", new Object[0]);
            return ExecuteResult.failure((Object)"ScriptParams is null.");
        }
        String scriptPath = this.prepareScriptFile(jobId, scriptParams);
        this.logInfo("Generate executable file successfully, path: {}", scriptPath);
        if (SnailJobSystemUtil.isOsWindows() && SH_SHELL.equals(this.getRunCommand())) {
            this.logWarn("Current OS is {} where shell scripts cannot run.", SnailJobSystemUtil.getOsName());
            return ExecuteResult.failure((Object)"Shell scripts cannot run on Windows.");
        }
        if (!SnailJobSystemUtil.isOsWindows()) {
            this.setScriptPermissions(scriptPath);
        }
        return this.executeScript(scriptPath, scriptParams);
    }

    private String prepareScriptFile(Long jobId, ScriptParams scriptParams) {
        Object scriptPath = WORKER_DIR + this.getScriptName(jobId);
        File script = new File((String)scriptPath);
        scriptPath = script.getAbsolutePath();
        this.ensureScriptDirectory(script);
        switch (scriptParams.getMethod()) {
            case "LOCAL_SCRIPT": {
                return this.handleLocalScript(script, (String)scriptPath, scriptParams.getScriptParams());
            }
            case "DOWNLOAD": {
                try {
                    SnailJobFileUtil.downloadFile((String)scriptParams.getScriptParams(), (File)script, (int)5000, (int)300000);
                }
                catch (IOException e) {
                    throw new SnailJobInnerExecutorException("[snail-job] Script download failed", (Throwable)e);
                }
                return scriptPath;
            }
            case "SCRIPT_CODE": {
                try {
                    this.writeScriptContent(script, scriptParams);
                }
                catch (IOException e) {
                    throw new SnailJobInnerExecutorException("[snail-job] Failed to write script", (Throwable)e);
                }
                return scriptPath;
            }
        }
        throw new SnailJobInnerExecutorException("[snail-job] Please correctly choose the script execution method.");
    }

    private String handleLocalScript(File script, String scriptPath, String processorInfo) {
        File routhFile = new File(processorInfo);
        if (routhFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(routhFile));
                 BufferedWriter bw = new BufferedWriter(new FileWriter(script));){
                String line;
                while ((line = br.readLine()) != null) {
                    bw.write(line);
                    bw.newLine();
                }
                bw.flush();
            }
            catch (IOException e) {
                throw new SnailJobInnerExecutorException("[snail-job] Local script write exception", (Throwable)e);
            }
            return scriptPath;
        }
        throw new SnailJobInnerExecutorException("File not found: {" + processorInfo + "}");
    }

    private void ensureScriptDirectory(File script) {
        try {
            File parentDir = script.getParentFile();
            if (!parentDir.exists()) {
                this.logInfo("Script directory does not exist, creating: {}", parentDir.getAbsolutePath());
                SnailJobFileUtil.mkdirs((File)parentDir);
            }
        }
        catch (SnailJobInnerExecutorException e) {
            throw new SnailJobInnerExecutorException("[snail-job] ensure script directory error", (Throwable)e);
        }
    }

    private void writeScriptContent(File script, ScriptParams scriptParams) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(script.toPath(), this.getScriptChartset(scriptParams), new OpenOption[0]);){
            writer.write(scriptParams.getScriptParams());
            this.logInfo("Script content written successfully to: {}", script.getAbsolutePath());
        }
    }

    private Charset getScriptChartset(ScriptParams scriptParams) {
        String charsetName = scriptParams.getCharset();
        if (StrUtil.isNotBlank((CharSequence)charsetName)) {
            try {
                return Charset.forName(charsetName);
            }
            catch (Exception e) {
                this.logWarn("[snail-job] Invalid charset:{} . Using default charset.", charsetName);
            }
        }
        return this.getCharset();
    }

    private void setScriptPermissions(String scriptPath) {
        ProcessBuilder chmodPb = new ProcessBuilder("/bin/chmod", "755", scriptPath);
        try {
            chmodPb.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new SnailJobInnerExecutorException("[snail-job] Failed to set script permissions", (Throwable)e);
        }
        this.logInfo("chmod 755 authorization complete, ready to start execution~", new Object[0]);
    }

    private ExecuteResult executeScript(String scriptPath, ScriptParams scriptParams) {
        ExecuteResult executeResult;
        ProcessBuilder pb = this.getScriptProcessBuilder(scriptPath);
        Process process = null;
        try {
            process = pb.start();
            executeResult = this.captureOutput(process, scriptParams);
        }
        catch (IOException | InterruptedException e) {
            throw new SnailJobInnerExecutorException("[snail-job] Script execution failed", (Throwable)e);
        }
        finally {
            if (process.isAlive()) {
                process.destroy();
                try {
                    boolean exited = process.waitFor(5L, TimeUnit.SECONDS);
                    if (!exited) {
                        process.destroyForcibly();
                        process.waitFor();
                    }
                    this.logWarn("Script execution failed, starting to terminate script operation", new Object[0]);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return executeResult;
    }

    private ExecuteResult captureOutput(Process process, ScriptParams scriptParams) throws InterruptedException {
        StringBuilder inputBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        CountDownLatch latch = new CountDownLatch(2);
        Charset scriptChartset = this.getScriptChartset(scriptParams);
        new Thread(() -> {
            this.captureStream(process.getInputStream(), inputBuilder, scriptChartset);
            latch.countDown();
        }).start();
        new Thread(() -> {
            this.captureStream(process.getErrorStream(), errorBuilder, scriptChartset);
            latch.countDown();
        }).start();
        boolean success = process.waitFor() == 0;
        latch.await();
        String result = this.formatResult(inputBuilder, errorBuilder);
        this.logInfo(result, new Object[0]);
        return success ? ExecuteResult.success((Object)"Script executed successfully.") : ExecuteResult.failure((Object)"Script execution failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStream(InputStream is, StringBuilder sb, Charset charset) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, charset));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            this.logWarn("Failed to capture stream.", e);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    private String formatResult(StringBuilder inputBuilder, StringBuilder errorBuilder) {
        return String.format("[INPUT]: %s;[ERROR]: %s", inputBuilder, errorBuilder);
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.logWarn("Failed to close stream.", e);
        }
    }

    protected abstract String getScriptName(Long var1);

    protected abstract String getRunCommand();

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    protected abstract ProcessBuilder getScriptProcessBuilder(String var1);

    private void logInfo(String msg, Object ... params) {
        SnailJobLog.REMOTE.info("[snail-job] " + msg, params);
    }

    private void logWarn(String msg, Object ... params) {
        SnailJobLog.REMOTE.warn("[snail-job] " + msg, params);
    }

    public static class SnailFileUtils {
        public static String workspace(SnailJobProperties snailJobProperties) {
            String workspaceByDKey = Optional.ofNullable(snailJobProperties).map(SnailJobProperties::getWorkspace).orElse("");
            if (StrUtil.isNotBlank((CharSequence)workspaceByDKey)) {
                SnailJobLog.LOCAL.info("[FileUtils] [workspace] use custom workspace: {}", new Object[]{workspaceByDKey});
                return workspaceByDKey;
            }
            String userHome = System.getProperty("user.home").concat("/snailJob/worker");
            SnailJobLog.LOCAL.info("[FileUtils] [workspace] use user.home as workspace: {}", new Object[]{userHome});
            return userHome;
        }
    }

    public static class ScriptParams {
        private String method;
        private String scriptParams;
        private String charset;

        @Generated
        public ScriptParams() {
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getScriptParams() {
            return this.scriptParams;
        }

        @Generated
        public String getCharset() {
            return this.charset;
        }

        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @Generated
        public void setScriptParams(String scriptParams) {
            this.scriptParams = scriptParams;
        }

        @Generated
        public void setCharset(String charset) {
            this.charset = charset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScriptParams)) {
                return false;
            }
            ScriptParams other = (ScriptParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$scriptParams = this.getScriptParams();
            String other$scriptParams = other.getScriptParams();
            if (this$scriptParams == null ? other$scriptParams != null : !this$scriptParams.equals(other$scriptParams)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScriptParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $scriptParams = this.getScriptParams();
            result = result * 59 + ($scriptParams == null ? 43 : $scriptParams.hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractScriptExecutor.ScriptParams(method=" + this.getMethod() + ", scriptParams=" + this.getScriptParams() + ", charset=" + this.getCharset() + ")";
        }
    }
}

