/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.handler;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.RpcClient;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientRegister
implements Lifecycle {
    private static final ScheduledExecutorService SCHEDULE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sj-client-register"));
    public static RpcClient CLIENT;
    public static final int REGISTER_TIME = 10;
    @Autowired
    private SnailJobProperties snailJobProperties;

    @Override
    public void start() {
        CLIENT = RequestBuilder.newBuilder().client(RpcClient.class).callback(rpcResult -> {
            if (StatusEnum.NO.getStatus().equals(rpcResult.getStatus())) {
                SnailJobLog.LOCAL.error("heartbeat check requestId:[{}] message:[{}]", new Object[]{rpcResult.getReqId(), rpcResult.getMessage()});
            }
        }).build();
        Map<String, String> labels = this.snailJobProperties.getLabels();
        Pair defaultLabel = SystemConstants.DEFAULT_LABEL;
        labels.put((String)defaultLabel.getKey(), (String)defaultLabel.getValue());
        SCHEDULE_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                CLIENT.beat("PING", labels);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Heartbeat sending failed", new Object[]{e});
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
    }
}

