/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook.mouse;

import org.jnativehook.mouse.NativeMouseEvent;

public class NativeMouseWheelEvent
extends NativeMouseEvent {
    private static final long serialVersionUID = 2112217673594181259L;
    public static final int WHEEL_UNIT_SCROLL = 1;
    public static final int WHEEL_BLOCK_SCROLL = 2;
    public static final int WHEEL_VERTICAL_DIRECTION = 3;
    public static final int WHEEL_HORIZONTAL_DIRECTION = 4;
    private int scrollAmount;
    private int scrollType;
    private int wheelRotation;
    private int wheelDirection;

    public NativeMouseWheelEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n, n2, n3, n4, n5, n6, n7, n8, 3);
    }

    public NativeMouseWheelEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n, n2, n3, n4, n5);
        this.scrollType = n6;
        this.scrollAmount = n7;
        this.wheelRotation = n8;
        this.wheelDirection = n9;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public int getScrollType() {
        return this.scrollType;
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    public int getWheelDirection() {
        return this.wheelDirection;
    }

    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.paramString());
        stringBuilder.append(",scrollType=");
        switch (this.getScrollType()) {
            case 1: {
                stringBuilder.append("WHEEL_UNIT_SCROLL");
                break;
            }
            case 2: {
                stringBuilder.append("WHEEL_BLOCK_SCROLL");
                break;
            }
            default: {
                stringBuilder.append("unknown scroll type");
            }
        }
        stringBuilder.append(",scrollAmount=");
        stringBuilder.append(this.getScrollAmount());
        stringBuilder.append(",wheelRotation=");
        stringBuilder.append(this.getWheelRotation());
        stringBuilder.append(",wheelDirection=");
        switch (this.getWheelDirection()) {
            case 3: {
                stringBuilder.append("WHEEL_VERTICAL_DIRECTION");
                break;
            }
            case 4: {
                stringBuilder.append("WHEEL_HORIZONTAL_DIRECTION");
                break;
            }
            default: {
                stringBuilder.append("unknown scroll direction");
            }
        }
        return stringBuilder.toString();
    }
}

