/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook;

import java.awt.Toolkit;
import java.util.EventObject;
import org.jnativehook.GlobalScreen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeInputEvent
extends EventObject {
    private static final long serialVersionUID = 2306729722565226621L;
    private int id;
    private long when;
    private int modifiers;
    private short reserved;
    public static final int SHIFT_L_MASK = 1;
    public static final int CTRL_L_MASK = 2;
    public static final int META_L_MASK = 4;
    public static final int ALT_L_MASK = 8;
    public static final int SHIFT_R_MASK = 16;
    public static final int CTRL_R_MASK = 32;
    public static final int META_R_MASK = 64;
    public static final int ALT_R_MASK = 128;
    public static final int SHIFT_MASK = 17;
    public static final int CTRL_MASK = 34;
    public static final int META_MASK = 68;
    public static final int ALT_MASK = 136;
    public static final int BUTTON1_MASK = 256;
    public static final int BUTTON2_MASK = 512;
    public static final int BUTTON3_MASK = 1024;
    public static final int BUTTON4_MASK = 2048;
    public static final int BUTTON5_MASK = 4096;
    public static final int NUM_LOCK_MASK = 8192;
    public static final int CAPS_LOCK_MASK = 16384;
    public static final int SCROLL_LOCK_MASK = 32768;

    public NativeInputEvent(Class<GlobalScreen> clazz, int n, int n2) {
        super(clazz);
        this.id = n;
        this.when = 0L;
        this.modifiers = n2;
        this.reserved = 0;
    }

    public int getID() {
        return this.id;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    private void setReserved(short s) {
        this.reserved = s;
    }

    public static String getModifiersText(int n) {
        StringBuilder stringBuilder = new StringBuilder(255);
        if ((n & 0x11) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuilder.append('+');
        }
        if ((n & 0x22) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuilder.append('+');
        }
        if ((n & 0x44) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuilder.append('+');
        }
        if ((n & 0x88) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuilder.append('+');
        }
        if ((n & 0x100) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button1", "Button1"));
            stringBuilder.append('+');
        }
        if ((n & 0x200) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button2", "Button2"));
            stringBuilder.append('+');
        }
        if ((n & 0x400) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button3", "Button3"));
            stringBuilder.append('+');
        }
        if ((n & 0x800) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button4", "Button4"));
            stringBuilder.append('+');
        }
        if ((n & 0x1000) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button5", "Button5"));
            stringBuilder.append('+');
        }
        if ((n & 0x2000) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.numLock", "Num Lock"));
            stringBuilder.append('+');
        }
        if ((n & 0x4000) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.capsLock", "Caps Lock"));
            stringBuilder.append('+');
        }
        if ((n & 0x8000) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.scrollLock", "Scroll Lock"));
            stringBuilder.append('+');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(255);
        stringBuilder.append("id=");
        stringBuilder.append(this.getID());
        stringBuilder.append(',');
        stringBuilder.append("when=");
        stringBuilder.append(this.getWhen());
        stringBuilder.append(',');
        stringBuilder.append("mask=");
        stringBuilder.append(Integer.toBinaryString(this.getModifiers()));
        stringBuilder.append(',');
        stringBuilder.append("modifiers=");
        stringBuilder.append(NativeInputEvent.getModifiersText(this.getModifiers()));
        return stringBuilder.toString();
    }
}

