/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import com.onespatial.dwglib.objects.SeqEnd;
import java.util.AbstractList;
import java.util.List;

public class TwoDPolyline
extends EntityObject {
    public boolean isClosed;
    public boolean curveFitVerticesAdded;
    public boolean splineFitVerticesAdded;
    public boolean is3DPolyline;
    public boolean is3DPolygonMesh;
    public boolean isMeshClosedInNDirection;
    public boolean isPolyfaceMesh;
    public boolean continuousLinetypePattern;
    public int curveType;
    public double startWidth;
    public double endWidth;
    public double thickness;
    public double elevation;
    public Point3D extrusion;
    private Handle[] ownedObjectHandles;
    private Handle seqEndHandle;

    public TwoDPolyline(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int flags = dataStream.getBS();
        this.isClosed = (flags & 1) != 0;
        this.curveFitVerticesAdded = (flags & 2) != 0;
        this.splineFitVerticesAdded = (flags & 4) != 0;
        this.is3DPolyline = (flags & 8) != 0;
        this.is3DPolygonMesh = (flags & 0x10) != 0;
        this.isMeshClosedInNDirection = (flags & 0x20) != 0;
        this.isPolyfaceMesh = (flags & 0x40) != 0;
        this.continuousLinetypePattern = (flags & 0x80) != 0;
        this.curveType = dataStream.getBS();
        this.startWidth = dataStream.getBD();
        this.endWidth = dataStream.getBD();
        this.thickness = dataStream.getBT();
        this.elevation = dataStream.getBD();
        this.extrusion = dataStream.getBE();
        int ownedObjectCount = dataStream.getBL();
        this.ownedObjectHandles = new Handle[ownedObjectCount];
        for (int i = 0; i < ownedObjectCount; ++i) {
            this.ownedObjectHandles[i] = handleStream.getHandle();
        }
        this.seqEndHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "2D POLYLINE";
    }

    public List<EntityObject> getOwnedObjects() {
        return new AbstractList<EntityObject>(){

            @Override
            public EntityObject get(int index) {
                CadObject result = TwoDPolyline.this.objectMap.parseObject(TwoDPolyline.this.ownedObjectHandles[index]);
                return (EntityObject)result;
            }

            @Override
            public int size() {
                return TwoDPolyline.this.ownedObjectHandles.length;
            }
        };
    }

    public SeqEnd getSeqEnd() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.seqEndHandle);
        return (SeqEnd)result;
    }
}

