/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Text
extends EntityObject {
    public double elevation;
    public Point2D insertionPoint;
    public Point2D alignmentPoint;
    public Point3D extrusion;
    public double thickness;
    public double obliqueAngle;
    public double rotationAngle;
    public double height;
    public double widthFactor;
    public String textValue;
    public int generation;
    public int horizontalAlignment;
    public int verticalAlignment;
    public Handle styleHandle;

    public Text(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int dataFlags = dataStream.getUnsignedRC();
        if ((dataFlags & 1) == 0) {
            this.elevation = dataStream.getRD();
        }
        this.insertionPoint = dataStream.get2RD();
        if ((dataFlags & 2) == 0) {
            this.alignmentPoint = dataStream.get2DD(this.insertionPoint);
        }
        this.extrusion = dataStream.getBE();
        this.thickness = dataStream.getBT();
        if ((dataFlags & 4) == 0) {
            this.obliqueAngle = dataStream.getRD();
        }
        if ((dataFlags & 8) == 0) {
            this.rotationAngle = dataStream.getRD();
        }
        this.height = dataStream.getRD();
        if ((dataFlags & 0x10) == 0) {
            this.widthFactor = dataStream.getRD();
        }
        this.textValue = stringStream.getTU();
        if ((dataFlags & 0x20) == 0) {
            this.generation = dataStream.getBS();
        }
        if ((dataFlags & 0x40) == 0) {
            this.horizontalAlignment = dataStream.getBS();
        }
        if ((dataFlags & 0x80) == 0) {
            this.verticalAlignment = dataStream.getBS();
        }
        this.styleHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "TEXT";
    }
}

