/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class SortEntsTable
extends NonEntityObject {
    private Handle[] sortHandles;
    private Handle ownerHandle;
    private Handle[] entityHandles;

    public SortEntsTable(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int i;
        int numEntries = dataStream.getBL();
        this.sortHandles = new Handle[numEntries];
        for (i = 0; i < numEntries; ++i) {
            this.sortHandles[i] = dataStream.getHandle();
        }
        this.ownerHandle = handleStream.getHandle(this.handleOfThisObject);
        this.entityHandles = new Handle[numEntries];
        for (i = 0; i < numEntries; ++i) {
            this.entityHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public List<CadObject> getSortObjects() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = SortEntsTable.this.objectMap.parseObjectPossiblyOrphaned(SortEntsTable.this.sortHandles[index]);
                return result;
            }

            @Override
            public int size() {
                return SortEntsTable.this.sortHandles.length;
            }
        };
    }

    public CadObject getOwner() {
        CadObject result = this.objectMap.parseObject(this.ownerHandle);
        return result;
    }

    public List<CadObject> getEntities() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = SortEntsTable.this.objectMap.parseObjectPossiblyOrphaned(SortEntsTable.this.entityHandles[index]);
                return result;
            }

            @Override
            public int size() {
                return SortEntsTable.this.entityHandles.length;
            }
        };
    }

    public String toString() {
        return "SORTENTSTABLE";
    }
}

