/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class PolylinePFace
extends EntityObject {
    public int numVertexes;
    public int numFaces;
    private Handle[] vertexHandles;
    private Handle seqEndHandle;

    public PolylinePFace(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.numVertexes = dataStream.getBS();
        this.numFaces = dataStream.getBS();
        int ownedObjectCount = dataStream.getBL();
        this.vertexHandles = new Handle[ownedObjectCount];
        for (int i = 0; i < ownedObjectCount; ++i) {
            this.vertexHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        this.seqEndHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "POLYLINE (PFACE)";
    }

    public List<EntityObject> getOwnedObjects() {
        return new AbstractList<EntityObject>(){

            @Override
            public EntityObject get(int index) {
                CadObject result = PolylinePFace.this.objectMap.parseObject(PolylinePFace.this.vertexHandles[index]);
                return (EntityObject)result;
            }

            @Override
            public int size() {
                return PolylinePFace.this.vertexHandles.length;
            }
        };
    }

    public CadObject getSeqEnd() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.seqEndHandle);
        return result;
    }
}

