/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class PolylineMesh
extends EntityObject {
    public int flags;
    public int curveType;
    public int mVertexCount;
    public int nVertexCount;
    public int mDensity;
    public int nDensity;
    private Handle[] vertexHandles;
    private Handle seqEndHandle;

    public PolylineMesh(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.flags = dataStream.getBS();
        this.curveType = dataStream.getBS();
        this.mVertexCount = dataStream.getBS();
        this.nVertexCount = dataStream.getBS();
        this.mDensity = dataStream.getBS();
        this.nDensity = dataStream.getBS();
        int ownedObjectCount = dataStream.getBL();
        this.vertexHandles = new Handle[ownedObjectCount];
        for (int i = 0; i < ownedObjectCount; ++i) {
            this.vertexHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        this.seqEndHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "POLYLINE (MESH)";
    }

    public List<EntityObject> getOwnedObjects() {
        return new AbstractList<EntityObject>(){

            @Override
            public EntityObject get(int index) {
                CadObject result = PolylineMesh.this.objectMap.parseObject(PolylineMesh.this.vertexHandles[index]);
                return (EntityObject)result;
            }

            @Override
            public int size() {
                return PolylineMesh.this.vertexHandles.length;
            }
        };
    }

    public CadObject getSeqEnd() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.seqEndHandle);
        return result;
    }
}

