/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.ArrayList;
import java.util.List;

public class LwPolyline
extends EntityObject {
    public Handle referencedHandle;
    public List<VertexOfLwPolyline> points;
    public Double constantWidth;
    public boolean isClosed;

    public LwPolyline(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int index;
        int numberOfPoints;
        boolean b1 = dataStream.getB();
        boolean b2 = dataStream.getB();
        int numberOfVariableWidths = 0;
        int numberOfBulges = 0;
        if (b1) {
            this.isClosed = true;
            numberOfPoints = dataStream.getBS();
        } else {
            boolean bit1 = dataStream.getB();
            boolean bit2 = dataStream.getB();
            boolean areVariableWidthsPresent = dataStream.getB();
            boolean areBulgesPresent = dataStream.getB();
            dataStream.expectB(false);
            boolean bitC = dataStream.getB();
            dataStream.expectB(false);
            dataStream.expectB(false);
            assert (!bit1);
            assert (!bit2);
            if (!areVariableWidthsPresent) {
                if (areBulgesPresent != bitC) {
                    System.out.println("different");
                }
                boolean hasWidth = areBulgesPresent;
                if (!b2) {
                    int flags17 = dataStream.getBitsUnsigned(8);
                    if (flags17 != 2) {
                        throw new RuntimeException("new case");
                    }
                    this.isClosed = true;
                    if (hasWidth) {
                        this.constantWidth = dataStream.getBD();
                        numberOfPoints = dataStream.getBS();
                        if (numberOfPoints == 0) {
                            System.out.println("it's gone wrong");
                        }
                        if (areVariableWidthsPresent == areBulgesPresent) {
                            System.out.println("here");
                        }
                        if (areVariableWidthsPresent && numberOfPoints != (numberOfVariableWidths = dataStream.getBS())) {
                            throw new RuntimeException();
                        }
                        if (areBulgesPresent && numberOfPoints != (numberOfBulges = dataStream.getBS())) {
                            throw new RuntimeException();
                        }
                    } else {
                        if (bitC) {
                            double d = dataStream.getBD();
                        }
                        if ((numberOfPoints = dataStream.getBS()) == 0) {
                            System.out.println("it's gone wrong");
                        }
                        numberOfVariableWidths = 0;
                        numberOfBulges = 0;
                    }
                } else {
                    this.isClosed = false;
                    this.constantWidth = dataStream.getBD();
                    numberOfPoints = dataStream.getBS();
                    if (numberOfPoints == 0) {
                        System.out.println("it's gone wrong");
                    }
                    numberOfVariableWidths = 0;
                    numberOfBulges = 0;
                    if (hasWidth) {
                        if (areVariableWidthsPresent == areBulgesPresent) {
                            System.out.println("");
                        }
                        if (areVariableWidthsPresent && (numberOfVariableWidths = dataStream.getBS()) != numberOfPoints) {
                            throw new RuntimeException();
                        }
                        if (areBulgesPresent && (numberOfBulges = dataStream.getBS()) != numberOfPoints) {
                            throw new RuntimeException();
                        }
                    }
                }
            } else {
                this.isClosed = false;
                if (!b2) {
                    System.out.println("this case fails");
                }
                if (areBulgesPresent || bitC) {
                    System.out.println("here");
                }
                numberOfPoints = dataStream.getBS();
                if (areVariableWidthsPresent ? (numberOfVariableWidths = dataStream.getBS()) != numberOfPoints : (numberOfBulges = dataStream.getBS()) != numberOfPoints) {
                    throw new RuntimeException();
                }
                if (numberOfPoints != 2 || numberOfVariableWidths != 2) {
                    System.out.println("here");
                }
            }
        }
        this.points = new ArrayList<VertexOfLwPolyline>(numberOfPoints);
        double x = dataStream.getRD();
        double y = dataStream.getRD();
        this.points.add(new VertexOfLwPolyline(x, y));
        for (index = 1; index < numberOfPoints; ++index) {
            x = dataStream.getDD(x);
            y = dataStream.getDD(y);
            this.points.add(new VertexOfLwPolyline(x, y));
        }
        for (index = 0; index < numberOfVariableWidths; ++index) {
            double startingWidth = dataStream.getBD();
            double endingWidth = dataStream.getBD();
            this.points.get(index).setVariableWidth(startingWidth, endingWidth);
        }
        for (index = 0; index < numberOfBulges; ++index) {
            double bulge = dataStream.getBD();
            this.points.get(index).setBulge(bulge);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LWPOLYLINE";
    }

    public static class VertexOfLwPolyline {
        public final Point2D vertex;
        public double startingWidth;
        public double endingWidth;
        public double bulge;

        public VertexOfLwPolyline(double x, double y) {
            this.vertex = new Point2D(x, y);
        }

        public String toString() {
            return this.vertex.toString();
        }

        public void setVariableWidth(double startingWidth, double endingWidth) {
            this.startingWidth = startingWidth;
            this.endingWidth = endingWidth;
        }

        public void setBulge(double bulge) {
            this.bulge = bulge;
        }
    }
}

