/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Leader
extends EntityObject {
    public int annotType;
    public int pathType;
    public Point3D[] points;
    public Point3D endPointProj;
    public Point3D extrusion;
    public Point3D xDirection;
    public Point3D offsetToBlockInsPt;
    public double unknown1;
    public double unknown2;
    public double unknown3;
    public boolean hooklineOnXDir;
    public boolean arrowHeadOn;
    public int unknownInt;
    public boolean unknownBit1;
    public boolean unknownBit2;
    private Handle annotationHandle;
    private Handle dimStyleHandle;

    public Leader(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        dataStream.expectB(false);
        this.annotType = dataStream.getBS();
        this.pathType = dataStream.getBS();
        int numberOfPoints = dataStream.getBL();
        this.points = new Point3D[numberOfPoints];
        for (int i = 0; i < numberOfPoints; ++i) {
            this.points[i] = dataStream.get3BD();
        }
        this.endPointProj = dataStream.get3BD();
        this.extrusion = dataStream.get3BD();
        this.xDirection = dataStream.get3BD();
        this.offsetToBlockInsPt = dataStream.get3BD();
        this.unknown1 = dataStream.getBD();
        this.unknown2 = dataStream.getBD();
        this.unknown3 = dataStream.getBD();
        this.hooklineOnXDir = dataStream.getB();
        this.arrowHeadOn = dataStream.getB();
        this.unknownInt = dataStream.getBS();
        this.unknownBit1 = dataStream.getB();
        this.unknownBit2 = dataStream.getB();
        this.annotationHandle = handleStream.getHandle();
        this.dimStyleHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LEADER";
    }

    public CadObject getAnnotation() {
        CadObject result = this.objectMap.parseObject(this.annotationHandle);
        return result;
    }

    public CadObject getDimStyle() {
        CadObject result = this.objectMap.parseObject(this.dimStyleHandle);
        return result;
    }
}

