/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.BlockHeader;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import com.onespatial.dwglib.objects.VPort;
import com.onespatial.dwglib.objects.ViewPort;
import java.util.AbstractList;
import java.util.List;

public class Layout
extends NonEntityObject {
    public String pageSetupName;
    public String printerOrConfig;
    public int plotLayoutFlags;
    public double leftMargin;
    public double bottomMargin;
    public double rightMargin;
    public double topMargin;
    public double paperWidth;
    public double paperHeight;
    public String paperSize;
    public Point2D plotOrigin;
    public int paperUnits;
    public int plotRotation;
    public int plotType;
    public Point2D windowMinimum;
    public Point2D windowMaximum;
    public double realWorldUnits;
    public double drawingUnits;
    public String currentStyleSheet;
    public int scaleType;
    public double scaleFactor;
    public Point2D paperImageOrigin;
    public int shadePlotMode;
    public int shadePlotResLevel;
    public int shadePlotCustomDpi;
    public String layoutName;
    public int tabOrder;
    public int flag;
    public Point3D ucsOrigin;
    public Point2D limitMinimum;
    public Point2D limitMaximum;
    public Point3D insertionPoint;
    public Point3D ucsXAxis;
    public Point3D ucsYAxis;
    public double elevation;
    public int orthographicViewType;
    public Point3D extentMinimum;
    public Point3D extentMaximum;
    private Handle plotViewHandle;
    private Handle visualStyleHandle;
    private Handle paperspaceBlockRecordHandle;
    private Handle lastActiveViewportHandle;
    private Handle baseUcsHandle;
    private Handle namedUcsHandle;
    private Handle[] viewportHandles;

    public Layout(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.pageSetupName = stringStream.getTU();
        this.printerOrConfig = stringStream.getTU();
        this.plotLayoutFlags = dataStream.getBS();
        this.leftMargin = dataStream.getBD();
        this.bottomMargin = dataStream.getBD();
        this.rightMargin = dataStream.getBD();
        this.topMargin = dataStream.getBD();
        this.paperWidth = dataStream.getBD();
        this.paperHeight = dataStream.getBD();
        this.paperSize = stringStream.getTU();
        this.plotOrigin = dataStream.get2BD();
        this.paperUnits = dataStream.getBS();
        this.plotRotation = dataStream.getBS();
        this.plotType = dataStream.getBS();
        this.windowMinimum = dataStream.get2BD();
        this.windowMaximum = dataStream.get2BD();
        this.realWorldUnits = dataStream.getBD();
        this.drawingUnits = dataStream.getBD();
        this.currentStyleSheet = stringStream.getTU();
        this.scaleType = dataStream.getBS();
        this.scaleFactor = dataStream.getBD();
        this.paperImageOrigin = dataStream.get2BD();
        this.shadePlotMode = dataStream.getBS();
        this.shadePlotResLevel = dataStream.getBS();
        this.shadePlotCustomDpi = dataStream.getBS();
        this.layoutName = stringStream.getTU();
        this.tabOrder = dataStream.getBS();
        this.flag = dataStream.getBS();
        this.ucsOrigin = dataStream.get3BD();
        this.limitMinimum = dataStream.get2RD();
        this.limitMaximum = dataStream.get2RD();
        this.insertionPoint = dataStream.get3BD();
        this.ucsXAxis = dataStream.get3BD();
        this.ucsYAxis = dataStream.get3BD();
        this.elevation = dataStream.getBD();
        this.orthographicViewType = dataStream.getBS();
        this.extentMinimum = dataStream.get3BD();
        this.extentMaximum = dataStream.get3BD();
        int viewportCount = dataStream.getBL();
        this.plotViewHandle = handleStream.getHandle();
        this.visualStyleHandle = handleStream.getHandle(this.handleOfThisObject);
        this.paperspaceBlockRecordHandle = handleStream.getHandle(this.handleOfThisObject);
        this.lastActiveViewportHandle = handleStream.getHandle(this.handleOfThisObject);
        this.baseUcsHandle = handleStream.getHandle();
        this.namedUcsHandle = handleStream.getHandle();
        this.viewportHandles = new Handle[viewportCount];
        for (int i = 0; i < viewportCount; ++i) {
            this.viewportHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public CadObject getPlotView() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.plotViewHandle);
        return result;
    }

    public CadObject getVisualStyle() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.visualStyleHandle);
        return result;
    }

    public BlockHeader getPaperspaceBlockRecord() {
        CadObject result = this.objectMap.parseObject(this.paperspaceBlockRecordHandle);
        return (BlockHeader)result;
    }

    public CadObject getLastActiveViewport() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.lastActiveViewportHandle);
        if (result != null && !(result instanceof VPort) && !(result instanceof ViewPort)) {
            throw new RuntimeException("unexpected object class");
        }
        return result;
    }

    public CadObject getBaseUcs() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.baseUcsHandle);
        return result;
    }

    public CadObject getNamedUcs() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.namedUcsHandle);
        return result;
    }

    public List<CadObject> getViewPorts() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = Layout.this.objectMap.parseObject(Layout.this.viewportHandles[index]);
                if (!(result instanceof VPort) && !(result instanceof ViewPort)) {
                    throw new RuntimeException("unexpected object class");
                }
                return result;
            }

            @Override
            public int size() {
                return Layout.this.viewportHandles.length;
            }
        };
    }

    public String toString() {
        return "LAYOUT";
    }
}

