/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.CmColor;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.AcdbPlaceHolder;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Layer
extends NonEntityObject {
    public String entryName;
    public CmColor color;
    private Handle externalReferenceBlockHandle;
    private Handle plotStyleHandle;
    private Handle lineTypeHandle;
    private Handle materialHandle;

    public Layer(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.entryName = stringStream.getTU();
        boolean sixtyFourFlag = dataStream.getB();
        boolean xdep = dataStream.getB();
        int flags = dataStream.getBS();
        this.color = dataStream.getCMC();
        this.externalReferenceBlockHandle = handleStream.getHandle();
        this.plotStyleHandle = handleStream.getHandle();
        this.materialHandle = handleStream.getHandle(this.handleOfThisObject);
        this.lineTypeHandle = handleStream.getHandle(this.handleOfThisObject);
        if (fileVersion.is2013OrLater()) {
            Handle handle = handleStream.getHandle();
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LAYER";
    }

    public CadObject getExternalReferenceBlock() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.externalReferenceBlockHandle);
        return result;
    }

    public AcdbPlaceHolder getPlotStyle() {
        CadObject result = this.objectMap.parseObject(this.plotStyleHandle);
        return (AcdbPlaceHolder)result;
    }

    public CadObject getLineType() {
        CadObject result = this.objectMap.parseObject(this.lineTypeHandle);
        return result;
    }

    public CadObject getMaterial() {
        CadObject result = this.objectMap.parseObject(this.materialHandle);
        return result;
    }
}

