/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.Appid;
import com.onespatial.dwglib.objects.Dictionary;
import com.onespatial.dwglib.objects.ObjectMap;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class CadObject {
    protected final ObjectMap objectMap;
    public Handle handleOfThisObject;
    protected Handle[] reactorHandles;
    private List<Handle> genericHandles = new ArrayList<Handle>();
    private Map<Handle, Object[]> extendedEntityData = new HashMap<Handle, Object[]>();
    protected Handle xdicobjhandle;

    public CadObject(ObjectMap objectMap) {
        this.objectMap = objectMap;
    }

    public void readFromStreams(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.handleOfThisObject = dataStream.getHandle();
        int sizeOfExtendedObjectData = dataStream.getBS();
        while (sizeOfExtendedObjectData != 0) {
            Handle appHandle = dataStream.getHandle();
            List<String> components = new ArrayList<Number>();
            Stack<ArrayList<Number>> componentStack = new Stack<ArrayList<Number>>();
            int expected = dataStream.position() + sizeOfExtendedObjectData * 8;
            block17: while (dataStream.position() < expected) {
                int dxfGroupCode = dataStream.getRC();
                switch (dxfGroupCode) {
                    case 0: {
                        int length = dataStream.getRC();
                        byte[] x = new byte[length * 2];
                        for (int i = 0; i < length * 2; ++i) {
                            x[i] = (byte)dataStream.getRC();
                        }
                        try {
                            String text = new String(x, "UTF-16");
                            components.add(text);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException("Should not happen");
                        }
                        int unknown = dataStream.getRC();
                        continue block17;
                    }
                    case 2: {
                        int x = dataStream.getRC();
                        switch (x) {
                            case 0: {
                                componentStack.push((ArrayList<Number>)components);
                                components = new ArrayList();
                                break;
                            }
                            case 1: {
                                ArrayList<Number> justCompletedList = components;
                                components = (List)componentStack.pop();
                                components.add((String)justCompletedList.toArray());
                            }
                        }
                        continue block17;
                    }
                    case 3: 
                    case 5: {
                        int[] handleBytes = dataStream.getBytes(8);
                        Handle handle = new Handle(5, handleBytes);
                        components.add((String)((Object)handle));
                        continue block17;
                    }
                    case 4: {
                        int length = dataStream.getRC();
                        byte[] x = new byte[length];
                        for (int i = 0; i < length; ++i) {
                            x[i] = (byte)dataStream.getRC();
                        }
                        components.add((String)x);
                        continue block17;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        double x = dataStream.getRD();
                        double y = dataStream.getRD();
                        double z = dataStream.getRD();
                        Point3D point = new Point3D(x, y, z);
                        components.add((String)((Object)point));
                        continue block17;
                    }
                    case 40: 
                    case 41: 
                    case 42: {
                        double x = dataStream.getRD();
                        components.add((String)((Object)Double.valueOf(x)));
                        continue block17;
                    }
                    case 70: {
                        int x = dataStream.getRS();
                        components.add((String)((Object)Short.valueOf((short)x)));
                        continue block17;
                    }
                    case 71: {
                        int x = dataStream.getRL();
                        components.add((String)((Object)Long.valueOf(x)));
                        continue block17;
                    }
                }
                throw new RuntimeException("Unexpected case");
            }
            assert (dataStream.position() == expected);
            this.extendedEntityData.put(appHandle, components.toArray());
            sizeOfExtendedObjectData = dataStream.getBS();
        }
        this.readPostCommonFields(dataStream, stringStream, handleStream, fileVersion);
    }

    protected abstract void readPostCommonFields(BitBuffer var1, BitBuffer var2, BitBuffer var3, FileVersion var4);

    protected void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        try {
            while (true) {
                Handle referencedHandle = handleStream.getHandle(this.handleOfThisObject);
                this.genericHandles.add(referencedHandle);
            }
        }
        catch (RuntimeException runtimeException) {
            handleStream.advanceToByteBoundary();
            handleStream.assertEndOfStream();
            return;
        }
    }

    public List<CadObject> getReactors() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                if (CadObject.this.reactorHandles[index] == null) {
                    return null;
                }
                CadObject result = CadObject.this.objectMap.parseObject(CadObject.this.reactorHandles[index]);
                return result;
            }

            @Override
            public int size() {
                return CadObject.this.reactorHandles.length;
            }
        };
    }

    public Dictionary getXDictionary() {
        if (this.xdicobjhandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.xdicobjhandle);
        return (Dictionary)result;
    }

    public Map<Appid, Object[]> getExtendedEntityData() {
        return new AbstractMap<Appid, Object[]>(){

            @Override
            public Set<Map.Entry<Appid, Object[]>> entrySet() {
                return new AbstractSet<Map.Entry<Appid, Object[]>>(){

                    @Override
                    public Iterator<Map.Entry<Appid, Object[]>> iterator() {
                        final Iterator iter = CadObject.this.extendedEntityData.entrySet().iterator();
                        return new Iterator<Map.Entry<Appid, Object[]>>(){

                            @Override
                            public boolean hasNext() {
                                return iter.hasNext();
                            }

                            @Override
                            public Map.Entry<Appid, Object[]> next() {
                                final Map.Entry e = (Map.Entry)iter.next();
                                return new Map.Entry<Appid, Object[]>(){

                                    @Override
                                    public Appid getKey() {
                                        return (Appid)CadObject.this.objectMap.parseObject((Handle)e.getKey());
                                    }

                                    @Override
                                    public Object[] getValue() {
                                        return (Object[])e.getValue();
                                    }

                                    @Override
                                    public Object[] setValue(Object[] arg0) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return CadObject.this.extendedEntityData.size();
                    }
                };
            }
        };
    }

    public Dictionary getXdicobj() {
        if (this.xdicobjhandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.xdicobjhandle);
        return (Dictionary)result;
    }

    public List<CadObject> getGenericObjects() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = CadObject.this.objectMap.parseObjectPossiblyNullOrOrphaned((Handle)CadObject.this.genericHandles.get(index));
                return result;
            }

            @Override
            public int size() {
                return CadObject.this.genericHandles.size();
            }
        };
    }
}

