/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.BlockHeader;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class BlockControlObj
extends NonEntityObject {
    private Handle[] blockObjectHandles;
    private Handle modelSpaceHandle;
    private Handle paperSpaceHandle;

    public BlockControlObj(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int numentries = dataStream.getBL();
        this.blockObjectHandles = new Handle[numentries];
        for (int i = 0; i < numentries; ++i) {
            this.blockObjectHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        this.modelSpaceHandle = handleStream.getHandle();
        this.paperSpaceHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "BLOCK CONTROL OBJ";
    }

    public List<BlockHeader> getBlockHeaders() {
        return new AbstractList<BlockHeader>(){

            @Override
            public BlockHeader get(int index) {
                CadObject result = BlockControlObj.this.objectMap.parseObjectPossiblyNull(BlockControlObj.this.blockObjectHandles[index]);
                return (BlockHeader)result;
            }

            @Override
            public int size() {
                return BlockControlObj.this.blockObjectHandles.length;
            }
        };
    }

    public CadObject getModelSpace() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.modelSpaceHandle);
        return result;
    }

    public CadObject getPaperSpace() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.paperSpaceHandle);
        return result;
    }
}

