/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.Appid;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class AppidControlObj
extends NonEntityObject {
    public Handle[] appidObjectHandles;

    public AppidControlObj(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int numentries = dataStream.getBL();
        this.appidObjectHandles = new Handle[numentries];
        for (int i = 0; i < numentries; ++i) {
            this.appidObjectHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "APPID CONTROL OBJ";
    }

    public List<Appid> getAppids() {
        return new AbstractList<Appid>(){

            @Override
            public Appid get(int index) {
                CadObject result = AppidControlObj.this.objectMap.parseObjectPossiblyNull(AppidControlObj.this.appidObjectHandles[index]);
                return (Appid)result;
            }

            @Override
            public int size() {
                return AppidControlObj.this.appidObjectHandles.length;
            }
        };
    }
}

