/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.bitstreams;

import com.onespatial.dwglib.Issues;
import com.onespatial.dwglib.bitstreams.CmColor;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.HandleType;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.bitstreams.Value;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class BitBuffer {
    private byte[] byteArray;
    private Issues issues;
    private int currentOffset;
    private int bitOffset;
    private int currentByte;
    private int endOffset;

    private BitBuffer(byte[] byteArray, Issues issues) {
        this.byteArray = byteArray;
        this.issues = issues;
        this.currentOffset = 0;
        this.currentByte = byteArray[0];
        this.bitOffset = 0;
        this.endOffset = byteArray.length * 8;
    }

    public static BitBuffer wrap(byte[] byteArray, Issues issues) {
        return new BitBuffer(byteArray, issues);
    }

    public void position(int offset) {
        this.currentOffset = offset / 8;
        this.currentByte = this.byteArray[this.currentOffset];
        this.bitOffset = offset % 8;
    }

    public int position() {
        return this.currentOffset * 8 + this.bitOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public boolean getB() {
        boolean result;
        if (!this.hasMoreData()) {
            throw new RuntimeException("end of stream reached unexpectedly");
        }
        int mask = 128 >> this.bitOffset;
        boolean bl = result = (this.currentByte & mask) != 0;
        if (this.bitOffset == 7) {
            this.currentByte = this.byteArray[++this.currentOffset];
            this.bitOffset = 0;
        } else {
            ++this.bitOffset;
        }
        return result;
    }

    public int getBB() {
        return this.getBitsUnsigned(2);
    }

    public int getRC() {
        boolean isNegative = this.getB();
        int value = this.getBitsUnsigned(7);
        return isNegative ? -value : value;
    }

    public int getUnsignedRC() {
        return this.getBitsUnsigned(8);
    }

    public int getRS() {
        int a = this.getBitsUnsigned(8);
        boolean isNegative = this.getB();
        int b = this.getBitsUnsigned(7);
        int value = a + (b << 8);
        return isNegative ? -value : value;
    }

    public int getRL() {
        int a = this.getBitsUnsigned(8);
        int b = this.getBitsUnsigned(8);
        int c = this.getBitsUnsigned(8);
        boolean isNegative = this.getB();
        int d = this.getBitsUnsigned(7);
        int value = a + (b << 8) + (c << 16) + (d << 24);
        return isNegative ? -value : value;
    }

    public int getBS() {
        int code = this.getBitsUnsigned(2);
        switch (code) {
            case 0: {
                return this.getRS();
            }
            case 1: {
                return this.getBitsUnsigned(8);
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 256;
            }
        }
        throw new RuntimeException("can't happen");
    }

    public int getBL() {
        int code = this.getBitsUnsigned(2);
        switch (code) {
            case 0: {
                return this.getRL();
            }
            case 1: {
                return this.getBitsUnsigned(8);
            }
            case 2: {
                return 0;
            }
            case 3: {
                throw new RuntimeException("unknown bitlong code of 0b11");
            }
        }
        throw new RuntimeException("can't happen");
    }

    public long getBLL() {
        int length = this.get3B();
        long result = 0L;
        int shift = 0;
        while (length-- != 0) {
            result |= (long)(this.getBitsUnsigned(8) << shift);
            shift += 8;
        }
        return result;
    }

    public double getBD() {
        int code = this.getBitsUnsigned(2);
        switch (code) {
            case 0: {
                return this.getRD();
            }
            case 1: {
                return 1.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                throw new RuntimeException("unknown bitdouble code of 0b11");
            }
        }
        throw new RuntimeException("can't happen");
    }

    public Point2D get2RD() {
        double x = this.getRD();
        double y = this.getRD();
        return new Point2D(x, y);
    }

    public Point2D get2DD(Point2D base) {
        double x = this.getDD(base.x);
        double y = this.getDD(base.y);
        return new Point2D(x, y);
    }

    public Point2D get2BD() {
        double x = this.getBD();
        double y = this.getBD();
        return new Point2D(x, y);
    }

    public Point3D get3BD() {
        double x = this.getBD();
        double y = this.getBD();
        double z = this.getBD();
        return new Point3D(x, y, z);
    }

    public double getRD() {
        long byte0 = this.getBitsUnsigned(8);
        long byte1 = this.getBitsUnsigned(8);
        long byte2 = this.getBitsUnsigned(8);
        long byte3 = this.getBitsUnsigned(8);
        long byte4 = this.getBitsUnsigned(8);
        long byte5 = this.getBitsUnsigned(8);
        long byte6 = this.getBitsUnsigned(8);
        long byte7 = this.getBitsUnsigned(8);
        return Double.longBitsToDouble(byte7 << 56 | byte6 << 48 | byte5 << 40 | byte4 << 32 | byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0);
    }

    public int get3B() {
        if (this.getB()) {
            if (this.getB()) {
                if (this.getB()) {
                    return 7;
                }
                return 6;
            }
            return 2;
        }
        return 0;
    }

    public Handle getHandle() {
        int code = this.getBitsUnsigned(4);
        int counter = this.getBitsUnsigned(4);
        int[] handle = new int[counter];
        for (int i = 0; i < counter; ++i) {
            handle[i] = this.getBitsUnsigned(8);
        }
        return new Handle(code, handle);
    }

    public Handle getHandle(Handle baseHandle) {
        int thisOffset;
        int code = this.getBitsUnsigned(4);
        int counter = this.getBitsUnsigned(4);
        int[] handle = new int[counter];
        for (int i = 0; i < counter; ++i) {
            handle[i] = this.getBitsUnsigned(8);
        }
        Handle tempHandle = new Handle(code, handle);
        switch (tempHandle.code) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                thisOffset = tempHandle.offset;
                break;
            }
            case 6: {
                thisOffset = baseHandle.offset + 1;
                break;
            }
            case 8: {
                thisOffset = baseHandle.offset - 1;
                break;
            }
            case 10: {
                thisOffset = baseHandle.offset + tempHandle.offset;
                break;
            }
            case 12: {
                thisOffset = baseHandle.offset - tempHandle.offset;
                break;
            }
            default: {
                throw new RuntimeException("bad case");
            }
        }
        return new Handle(5, thisOffset);
    }

    public int getBitsUnsigned(int numberOfBits) {
        assert (numberOfBits <= 31);
        int result = 0;
        for (int i = 0; i < numberOfBits; ++i) {
            result <<= 1;
            if (!this.getB()) continue;
            ++result;
        }
        return result;
    }

    public String getTU() {
        int length = this.getBS();
        byte[] x = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            x[2 * i + 1] = (byte)this.getBitsUnsigned(8);
            x[2 * i] = (byte)this.getBitsUnsigned(8);
        }
        try {
            return new String(x, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean hasMoreData() {
        return this.currentOffset * 8 + this.bitOffset < this.endOffset;
    }

    public void B(Value<Boolean> value) {
        value.set(this.getB());
    }

    public void BS(Value<Integer> value) {
        value.set(this.getBS());
    }

    public void BL(Value<Integer> value) {
        value.set(this.getBL());
    }

    public void BD(Value<Double> value) {
        value.set(this.getBD());
    }

    public void RC(Value<Integer> value) {
        value.set(this.getRC());
    }

    public void expectB(boolean expected) {
        boolean actual = this.getB();
        if (actual != expected) {
            this.issues.addWarning(MessageFormat.format("Unknown bit value: {0} expected but {1} found. Investigation needed.", expected, actual));
        }
    }

    public void expectRC(int expected) {
        int actual = this.getRC();
        if (actual != expected) {
            this.issues.addWarning(MessageFormat.format("Unknown RC value: {0} expected but {1} found. Investigation needed.", expected, actual));
        }
    }

    public void expectBD(double expected) {
        double actual = this.getBD();
        if (actual != expected) {
            this.issues.addWarning(MessageFormat.format("Unknown bit-double value: {0} expected but {1} found. Investigation needed.", expected, actual));
        }
    }

    public void CMC(Value<CmColor> color) {
        int expectZero = this.getBS();
        int rgbValue = this.getBL();
        int colorByte = this.getRC();
        if ((colorByte & 1) != 0) {
            // empty if block
        }
        if ((colorByte & 2) != 0) {
            // empty if block
        }
        color.set(new CmColor(rgbValue, colorByte));
    }

    public void H(Value<Handle> value) {
        Handle handle = this.getHandle();
        value.set(handle);
    }

    public void H(Value<Handle> value, HandleType type) {
        Handle handle = this.getHandle();
        value.set(handle);
    }

    public void threeBD(Value<Point3D> field) {
        double x = this.getBD();
        double y = this.getBD();
        double z = this.getBD();
        field.set(new Point3D(x, y, z));
    }

    public void twoRD(Value<Point2D> field) {
        double x = this.getRD();
        double y = this.getRD();
        field.set(new Point2D(x, y));
    }

    public void TU(Value<String> field) {
        String text = this.getTU();
        field.set(text);
    }

    public int getOT() {
        int code = this.getBitsUnsigned(2);
        switch (code) {
            case 0: {
                return this.getBitsUnsigned(8);
            }
            case 1: {
                return this.getBitsUnsigned(8) + 496;
            }
            case 2: 
            case 3: {
                int loByte = this.getBitsUnsigned(8);
                int hiByte = this.getBitsUnsigned(8);
                return hiByte << 8 | loByte;
            }
        }
        throw new RuntimeException("cannot happen");
    }

    public void advanceToByteBoundary() {
        if (this.bitOffset != 0) {
            this.currentByte = this.byteArray[++this.currentOffset];
            this.bitOffset = 0;
        }
    }

    public void assertEndOfStream() {
        int currentBitOffset = this.currentOffset * 8 + this.bitOffset;
        if (currentBitOffset != this.endOffset) {
            throw new RuntimeException("not at end of stream");
        }
    }

    public CmColor getCMC() {
        int colorIndex = this.getBS();
        if (colorIndex == 0) {
            int rgbValue = this.getBL();
            int colorByte = this.getRC();
            return new CmColor(rgbValue, colorByte);
        }
        return new CmColor(0, 0);
    }

    public CmColor getENC() {
        int colorIndex = this.getBS();
        if ((colorIndex & 0x2000) != 0) {
            int n = this.getBL();
        }
        return new CmColor(0, 0);
    }

    public double getDD(double defaultValue) {
        int code = this.getBitsUnsigned(2);
        switch (code) {
            case 0: {
                return defaultValue;
            }
            case 1: {
                long b = Double.doubleToLongBits(defaultValue);
                long byte1 = this.getBitsUnsigned(8);
                long byte2 = this.getBitsUnsigned(8);
                long byte3 = this.getBitsUnsigned(8);
                long byte4 = this.getBitsUnsigned(8);
                return Double.longBitsToDouble(byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1 << 0 | b & 0xFFFFFFFF00000000L);
            }
            case 2: {
                long b = Double.doubleToLongBits(defaultValue);
                long byte1 = this.getBitsUnsigned(8);
                long byte2 = this.getBitsUnsigned(8);
                long byte3 = this.getBitsUnsigned(8);
                long byte4 = this.getBitsUnsigned(8);
                long byte5 = this.getBitsUnsigned(8);
                long byte6 = this.getBitsUnsigned(8);
                return Double.longBitsToDouble(byte2 << 40 | byte1 << 32 | byte6 << 24 | byte5 << 16 | byte4 << 8 | byte3 << 0 | b & 0xFFFF000000000000L);
            }
            case 3: {
                return this.getRD();
            }
        }
        throw new RuntimeException("cannot happen");
    }

    public int[] getBytes(int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getBitsUnsigned(8);
        }
        return result;
    }

    public Point3D getBE() {
        boolean extrusionBit = this.getB();
        if (extrusionBit) {
            return new Point3D(0.0, 0.0, 1.0);
        }
        return this.get3BD();
    }

    public double getBT() {
        boolean thicknessBit = this.getB();
        if (thicknessBit) {
            return 0.0;
        }
        return this.getBD();
    }
}

