/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib;

public class Expander {
    byte[] compressedData;
    byte[] result;
    private int inputPosition = 0;
    private int outputPosition = 0;

    public Expander(byte[] compressedData, int uncompressedSize) {
        this.compressedData = compressedData;
        this.result = this.expand(uncompressedSize);
    }

    private byte[] expand(int uncompressedSize) {
        int opcode1;
        byte[] outputBytes = new byte[uncompressedSize];
        int initialLitCount = this.getLitLength();
        for (int i = 0; i < initialLitCount; ++i) {
            outputBytes[this.outputPosition++] = this.compressedData[this.inputPosition++];
        }
        while ((opcode1 = this.getUnsignedByte()) != 17) {
            int i;
            int litCount;
            int compOffset;
            int compressedBytes;
            if (opcode1 < 16) {
                throw new RuntimeException("bad data???");
            }
            if (opcode1 == 16) {
                compressedBytes = this.getLongCompressionOffset() + 9;
                TwoByteOffset twoByteOffset = this.getTwoByteOffset();
                compOffset = twoByteOffset.reducedCompOffset + 16383;
                litCount = twoByteOffset.litCount;
            } else if (opcode1 <= 31) {
                assert (opcode1 >= 18 && opcode1 <= 31);
                compressedBytes = (opcode1 & 0xF) + 2;
                TwoByteOffset twoByteOffset = this.getTwoByteOffset();
                compOffset = twoByteOffset.reducedCompOffset + 16383;
                litCount = twoByteOffset.litCount;
            } else if (opcode1 == 32) {
                compressedBytes = this.getLongCompressionOffset() + 33;
                TwoByteOffset twoByteOffset = this.getTwoByteOffset();
                compOffset = twoByteOffset.reducedCompOffset;
                litCount = twoByteOffset.litCount;
            } else if (opcode1 <= 63) {
                assert (opcode1 >= 33 && opcode1 <= 63);
                compressedBytes = opcode1 - 30;
                TwoByteOffset twoByteOffset = this.getTwoByteOffset();
                compOffset = twoByteOffset.reducedCompOffset;
                litCount = twoByteOffset.litCount;
            } else {
                assert (opcode1 >= 64);
                compressedBytes = ((opcode1 & 0xF0) >> 4) - 1;
                int opcode2 = this.getUnsignedByte();
                compOffset = opcode2 << 2 | (opcode1 & 0xC) >> 2;
                litCount = opcode1 & 3;
                if (litCount == 0) {
                    litCount = this.getLitLength();
                }
            }
            int duplicateFromPosition = this.outputPosition - compOffset - 1;
            for (i = 0; i < compressedBytes; ++i) {
                outputBytes[this.outputPosition++] = outputBytes[duplicateFromPosition++];
            }
            for (i = 0; i < litCount; ++i) {
                outputBytes[this.outputPosition++] = this.compressedData[this.inputPosition++];
            }
        }
        return outputBytes;
    }

    private int getLitLength() {
        int opcode = this.peekUnsignedByte();
        if (opcode > 15) {
            return 0;
        }
        this.getUnsignedByte();
        int runningTotal = 0;
        if (opcode == 0) {
            runningTotal += 15;
            while ((opcode = this.getUnsignedByte()) == 0) {
                runningTotal += 255;
            }
        }
        return runningTotal + opcode + 3;
    }

    private int getLongCompressionOffset() {
        int opcode;
        int runningTotal = 0;
        while ((opcode = this.getUnsignedByte()) == 0) {
            runningTotal += 255;
        }
        return runningTotal + opcode;
    }

    private TwoByteOffset getTwoByteOffset() {
        int firstByte = this.getUnsignedByte();
        int secondByte = this.getUnsignedByte();
        int reducedCompOffset = firstByte >> 2 | secondByte << 6;
        int litCount = firstByte & 3;
        if (litCount == 0) {
            litCount = this.getLitLength();
        }
        return new TwoByteOffset(reducedCompOffset, litCount);
    }

    private int getUnsignedByte() {
        return this.compressedData[this.inputPosition++] & 0xFF;
    }

    private int peekUnsignedByte() {
        return this.compressedData[this.inputPosition] & 0xFF;
    }

    private class TwoByteOffset {
        public final int reducedCompOffset;
        public final int litCount;

        public TwoByteOffset(int reducedCompOffset, int litCount) {
            this.reducedCompOffset = reducedCompOffset;
            this.litCount = litCount;
        }
    }
}

