/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.auto.util;

import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.zxp.esclientrhl.auto.intfproxy.ESCRepository;
import org.zxp.esclientrhl.auto.intfproxy.RepositoryFactorySupport;
import org.zxp.esclientrhl.auto.util.EnableESTools;

public abstract class AbstractESCRegister {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void registerBeanDefinitions(BeanFactory factory, Environment environment, ResourceLoader resourceLoader, AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        this.getCandidates(annotationMetadata, registry, environment, resourceLoader).forEach(beanDefinition -> {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RepositoryFactorySupport.class);
            String beanClassName = beanDefinition.getBeanClassName();
            beanDefinitionBuilder.addConstructorArgValue((Object)beanClassName);
            AbstractBeanDefinition bd = beanDefinitionBuilder.getRawBeanDefinition();
            String beanName = beanClassName.substring(beanClassName.lastIndexOf(".") + 1);
            if (EnableESTools.isPrintregmsg()) {
                this.logger.info("generate ESCRegistrar beanClassName:" + beanClassName);
                this.logger.info("generate ESCRegistrar beanName:" + beanName);
            }
            BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)factory;
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        });
    }

    public Stream<BeanDefinition> getCandidates(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry, Environment environment, ResourceLoader resourceLoader) {
        ESCRepositoryComponentProvider scanner = new ESCRepositoryComponentProvider(registry);
        scanner.setEnvironment(environment);
        scanner.setResourceLoader(resourceLoader);
        return this.getBasePackage(annotationMetadata).flatMap(it -> scanner.findCandidateComponents((String)it).stream());
    }

    public abstract Stream<String> getBasePackage(AnnotationMetadata var1);

    private static class InterfaceTypeFilter
    extends AssignableTypeFilter {
        public InterfaceTypeFilter(Class<?> targetType) {
            super(targetType);
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return metadataReader.getClassMetadata().isInterface() && super.match(metadataReader, metadataReaderFactory);
        }
    }

    private static class ESCRepositoryComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        private BeanDefinitionRegistry registry;

        public ESCRepositoryComponentProvider(BeanDefinitionRegistry registry) {
            super(false);
            Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
            super.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(ESCRepository.class));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            boolean isNonRepositoryInterface = !ESCRepositoryComponentProvider.isGenericRepositoryInterface(beanDefinition.getBeanClassName());
            boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
            boolean isConsiderNestedRepositories = false;
            return isNonRepositoryInterface && (isTopLevelType || isConsiderNestedRepositories);
        }

        private static boolean isGenericRepositoryInterface(@Nullable String interfaceName) {
            return ESCRepository.class.getName().equals(interfaceName);
        }
    }
}

