/*
 * Decompiled with CFR 0.152.
 */
package org.zxp.esclientrhl.auto.autoindex;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.zxp.esclientrhl.annotation.ESMetaData;
import org.zxp.esclientrhl.auto.util.EnableESTools;
import org.zxp.esclientrhl.index.ElasticsearchIndex;
import org.zxp.esclientrhl.util.IndexTools;
import org.zxp.esclientrhl.util.MetaData;

@Configuration
public class CreateIndex
implements ApplicationListener,
ApplicationContextAware {
    @Autowired
    ElasticsearchIndex elasticsearchIndex;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ApplicationEvent event) {
        Map beansWithAnnotationMap = this.applicationContext.getBeansWithAnnotation(ESMetaData.class);
        beansWithAnnotationMap.forEach((beanName, bean) -> {
            try {
                MetaData metaData = IndexTools.getMetaData(bean.getClass());
                if (metaData.isAlias()) {
                    this.elasticsearchIndex.createAlias(bean.getClass());
                } else if (!this.elasticsearchIndex.exists(bean.getClass())) {
                    this.elasticsearchIndex.createIndex(bean.getClass());
                    if (EnableESTools.isPrintregmsg()) {
                        this.logger.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f\uff0c\u7d22\u5f15\u540d\u79f0\uff1a" + metaData.getIndexname() + "\u7d22\u5f15\u7c7b\u578b\uff1a" + metaData.getIndextype());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u521b\u5efa\u7d22\u5f15\u4e0d\u6210\u529f", (Throwable)e);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

