/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.rt.Trace;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DefaultTrace
extends Trace
implements JCoTraceListener {
    public final String STDOUT = "stdout";
    public final String STDERR = "stderr";
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private static final SimpleDateFormat fmtFileName = new SimpleDateFormat("'JCO'yyyyMMdd'_'HHmmssSSS", Locale.ENGLISH);
    private static final SimpleDateFormat fmtTime = new SimpleDateFormat("HH':'mm':'ss':'SSS", Locale.ENGLISH);
    private static Object monitor = new Object();
    private static int jcoTraceLevel = 0;
    private static String jcoTracePath = null;
    private static JCoTraceListener singleton = null;
    private String baseTraceFileName = "";
    private File traceFile = null;
    private Writer traceWriter = null;
    private int files_count = 0;

    public void setTrace(int level, String path) {
        if (level > 10) {
            level = 10;
        }
        if (level < jcoTraceLevel) {
            level = jcoTraceLevel;
        }
        Trace.setJCoTrace(level);
        if (path == null || !path.equals(jcoTracePath)) {
            if (!this.isStandardOutputOn()) {
                this.closeTraceWriter();
            }
            jcoTracePath = path;
        }
    }

    public static int getStandaloneTraceLevel(int internalLevel) {
        return Trace.toExternalTraceLevel(internalLevel);
    }

    public static int getInternalTraceLevel(int standaloneLevel) {
        return Trace.toInternalTraceLevel(standaloneLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCoTraceListener getListener() {
        Object object = monitor;
        synchronized (object) {
            if (singleton == null) {
                singleton = new DefaultTrace();
            }
            return singleton;
        }
    }

    public boolean isStandardOutputOn() {
        return jcoTracePath == null || jcoTracePath.equals("stdout") || jcoTracePath.equals("stderr");
    }

    private Writer createNewFile(File file) {
        try {
            OutputStreamWriter writer = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
                fos.flush();
            }
            catch (UnsupportedEncodingException e) {
                writer = new OutputStreamWriter(new FileOutputStream(file));
            }
            return writer;
        }
        catch (IOException ex) {
            throw new RuntimeException("JCO-TraceWriter: cannot open trace file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTraceWriter() {
        try {
            Object object = monitor;
            synchronized (object) {
                if (this.traceWriter != null) {
                    this.traceWriter.close();
                    this.traceWriter = null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Writer getWriter() {
        if (this.traceWriter != null) {
            try {
                if (this.traceFile == null || this.traceFile.length() <= 0x1400000L) return this.traceWriter;
                this.traceWriter.close();
                this.traceFile = new File(new StringBuilder(this.baseTraceFileName.length() + 9).append(this.baseTraceFileName).append('.').append(++this.files_count).append(".trc").toString());
                this.traceWriter = new BufferedWriter(this.createNewFile(this.traceFile));
                Trace.writeInfo(this);
                return this.traceWriter;
            }
            catch (IOException ex) {
                throw new RuntimeException("TraceWriter exception: " + ex.toString(), ex);
            }
        } else {
            String path = "stdout";
            if (jcoTracePath != null) {
                path = jcoTracePath;
            }
            if (path.equalsIgnoreCase("stdout")) {
                this.traceWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                path = "stdout";
            } else if (path.equalsIgnoreCase("stderr")) {
                this.traceWriter = new BufferedWriter(new OutputStreamWriter(System.err));
                path = "stderr";
            } else {
                if (!new File(path).isDirectory()) {
                    path = ".";
                }
                StringBuilder traceFileName = new StringBuilder(path.length() + 26).append(path).append(File.separatorChar).append(fmtFileName.format(new Date()));
                this.baseTraceFileName = traceFileName.toString();
                traceFileName.append(".trc");
                this.traceFile = new File(traceFileName.toString());
                this.traceWriter = new BufferedWriter(this.createNewFile(this.traceFile));
            }
            jcoTracePath = path;
            Trace.writeInfo(this);
        }
        return this.traceWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int messageLevel, String message) {
        try {
            Object object = monitor;
            synchronized (object) {
                Writer currTrcWriter = this.getWriter();
                currTrcWriter.write(Thread.currentThread().getName());
                currTrcWriter.write(" [");
                currTrcWriter.write(fmtTime.format(new Date()));
                currTrcWriter.write("]: ");
                currTrcWriter.write(message);
                currTrcWriter.write(10);
                currTrcWriter.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

