/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.json.Field;
import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import com.sap.conn.jco.rt.json.JSonContainerReader;
import com.sap.conn.jco.rt.json.JSonParser;
import java.io.IOException;

class JSonStructureReader
extends JSonContainerReader {
    DefaultRecordMetaData md;

    JSonStructureReader(JSonParser parser) {
        super(parser);
    }

    JSonStructureReader read(String name) throws IOException {
        this.md = (DefaultRecordMetaData)JCo.createRecordMetaData(name);
        this.readStructureAttributes();
        this.md.lock();
        this.repo.addRecordMetaDataToCache(this.md);
        return this;
    }

    void readStructureAttributes() throws IOException {
        int ucLen = 0;
        int nucLen = 0;
        boolean isNestedType = false;
        while (this.parser.nextNonBlankChar() == 44) {
            String attribute = this.parser.nextString();
            this.parser.assertChar(':');
            if ("nestingType".equals(attribute)) {
                isNestedType = this.parser.nextInt() == 1;
                continue;
            }
            if ("nucLength".equals(attribute)) {
                nucLen = this.parser.nextInt();
                continue;
            }
            if ("ucLength".equals(attribute)) {
                ucLen = this.parser.nextInt();
                continue;
            }
            if ("fields".equals(attribute)) {
                this.readFields();
                continue;
            }
            throw new JCoRepositorySerializationException("unknown STRUCTURE attribute \"" + attribute + "\"", this.parser);
        }
        this.md.setRecordLength(nucLen, ucLen);
        if (isNestedType) {
            this.md.markAsNestedType1Structure();
        }
        this.parser.undo();
    }

    void setField(Field f) {
        if (f.ucOffset == -1 || f.nucOffset == -1) {
            throw new JCoRepositorySerializationException("missing offsets for field " + f.name + " of structure " + this.md.getName());
        }
        int type = AbstractMetaData.getJCOType(f.type);
        this.md.add(f.name, type, f.nucLength, f.nucOffset, f.ucLength, f.ucOffset, f.decimals, f.descr, f.ddicName, null);
    }
}

