/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoCustomDestination;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcCustomizedDestination;
import com.sap.conn.jco.rt.RfcDestination;
import java.util.Map;
import java.util.Properties;

public final class RfcCustomDestination
extends RfcCustomizedDestination
implements JCoCustomDestination.SncConfigurationData,
JCoCustomDestination.UserData,
JCoCustomDestination {
    private static final String SPACE = " ";
    private static final String CUSTOM_DESTINATION = "custom destination";

    protected RfcCustomDestination(String name, Properties properties, RfcDestination parent) {
        super(name, properties, CUSTOM_DESTINATION, parent);
    }

    protected RfcCustomDestination(String name, Properties properties, RfcDestination parent, String scope) {
        super(name, properties, CUSTOM_DESTINATION, parent);
        this.scopeType = scope;
    }

    public JCoCustomDestination.SncConfigurationData getSNCConfiguration() {
        return this;
    }

    public JCoCustomDestination.UserData getUserLogonData() {
        return this;
    }

    private void checkState() {
        if (this.isInitialized) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", new StringBuilder(190).append("Destination instance is already connected, hence changes in the destination parameters are not allowed. ").append("If you need to change a setting create a new instance with createCustomDestination().").toString());
        }
    }

    private void setProperty(String key, String value) {
        if (!this.properties.getClass().equals(Properties.class)) {
            this.properties.put(key, SPACE);
            if (!SPACE.equals(this.properties.getProperty(key))) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.properties);
                this.properties = props;
            }
        }
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public void setCodepage(String codepage) {
        this.checkState();
        this.setProperty("jco.client.codepage", codepage);
    }

    public void setTrace(boolean trace) {
        this.checkState();
        this.setProperty("jco.client.trace", trace ? "1" : "0");
    }

    public void setUseSapGui(boolean useSapGui) {
        this.checkState();
        this.setProperty("jco.client.use_sapgui", useSapGui ? "2" : "0");
    }

    public void setRepositoryDestination(JCoDestination destination) throws JCoException {
        if (destination == null) {
            this.properties.remove("jco.destination.repository_destination");
            this.repositoryDestination = null;
            this.repository = null;
            return;
        }
        if (!(destination instanceof InternalDestination)) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instances that have been created by the JCo runtime are allowed. Passed destination " + destination.getDestinationName() + " is an instance of class " + destination.getClass().getName());
        }
        InternalDestination repoDest = ((InternalDestination)destination).getRepositoryDestination();
        if (repoDest == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instances whose repository destination refer to an SAP AS ABAP system are allowed. Passed destination " + destination.getDestinationName() + " is an instance of class " + destination.getClass().getName() + " and returned null for its repository destination");
        }
        String repoDestName = repoDest.getDestinationName();
        this.setProperty("jco.destination.repository_destination", repoDestName.equals(this.getDestinationName()) ? null : repoDestName);
        if (repoDest != this.repositoryDestination) {
            this.repositoryDestination = repoDest;
            this.repository = null;
        }
    }

    public void setSncLibrary(String sncLibrary) {
        this.checkState();
        this.setProperty("jco.client.snc_lib", sncLibrary);
    }

    public void setSncMode(String sncMode) {
        this.checkState();
        if (!"1".equals(sncMode) && !"0".equals(sncMode) && sncMode != null) {
            throw new IllegalArgumentException("sncMode must be 1 or 0");
        }
        this.setProperty("jco.client.snc_mode", sncMode);
        this.evaluateUserId();
    }

    public void setSncMyName(String sncMyName) {
        this.checkState();
        this.setProperty("jco.client.snc_myname", sncMyName);
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setSncPartnerName(String sncPartnerName) {
        this.checkState();
        this.setProperty("jco.client.snc_partnername", sncPartnerName);
    }

    public void setSncQOP(String sncQOP) {
        this.checkState();
        if (!(sncQOP == null || sncQOP.length() == 1 && Character.isDigit(sncQOP.charAt(0)))) {
            throw new IllegalArgumentException("sncQOP must be in range [0..9]");
        }
        this.setProperty("jco.client.snc_qop", sncQOP);
    }

    public void setSncWithSSO(boolean useSingleSignOn) {
        this.checkState();
        this.setProperty("jco.client.snc_sso", useSingleSignOn ? "1" : "0");
        this.evaluateUserId();
    }

    public void setAliasUser(String aliasUser) {
        this.checkState();
        this.setProperty("jco.client.alias_user", aliasUser);
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setClient(String client) {
        this.checkState();
        this.setProperty("jco.client.client", client);
    }

    public void setLanguage(String lang) {
        this.checkState();
        this.setProperty("jco.client.lang", lang);
    }

    public void setPassword(String passwd) {
        this.checkState();
        this.setProperty("jco.client.passwd", passwd);
    }

    public void setUser(String user) {
        this.checkState();
        this.setProperty("jco.client.user", user);
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setSSOTicket(String base64CodedSSOTicket) {
        this.checkState();
        this.setProperty("jco.client.mysapsso2", base64CodedSSOTicket);
        this.updateSSOTicket = true;
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setX509Certificate(String base64CodedCertificate) {
        this.checkState();
        this.setProperty("jco.client.x509cert", base64CodedCertificate);
        this.updateX509Certificate = true;
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setExternalIDData(String extIDData) {
        this.checkState();
        this.setProperty("jco.client.extid_data", extIDData);
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setExternalIDType(String extIDType) {
        this.checkState();
        this.setProperty("jco.client.extid_type", extIDType);
        this.evaluateUserId();
        if (this.withCurrentUser) {
            this.withCurrentUser = false;
            this.properties.remove("jco.destination.auth_type");
        }
    }

    public void setLogonCheck(int lcheck) {
        this.checkState();
        this.setProperty("jco.client.lcheck", lcheck == 0 ? "0" : null);
    }

    public void requestSSOTicket(boolean request) {
        this.checkState();
        this.setProperty("jco.client.getsso2", request ? "1" : "0");
    }
}

