/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.okhttp;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class CookiesManager
implements CookieJar {
    private final Map<String, List<Cookie>> cookieStore = new ConcurrentHashMap<String, List<Cookie>>();

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> cookies) {
        this.cookieStore.put(httpUrl.host(), cookies);
    }

    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        ArrayList cookies = this.cookieStore.get(httpUrl.host());
        return cookies != null ? cookies : new ArrayList();
    }

    public void addCookie(URI uri, Cookie cookie) {
        LinkedList<Cookie> cookieList = this.cookieStore.get(uri.getHost()) != null ? this.cookieStore.get(uri.getHost()) : new LinkedList<Cookie>();
        cookieList.add(cookie);
        this.cookieStore.put(uri.getHost(), cookieList);
    }
}

