/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.xpath.model;

import cn.wanghaomiao.xpath.core.XpathEvaluator;
import cn.wanghaomiao.xpath.exception.NoSuchAxisException;
import cn.wanghaomiao.xpath.exception.NoSuchFunctionException;
import cn.wanghaomiao.xpath.exception.XpathSyntaxErrorException;
import cn.wanghaomiao.xpath.model.JXNode;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class JXDocument {
    private Elements elements;
    private XpathEvaluator xpathEva = new XpathEvaluator();

    public JXDocument(Document doc) {
        this.elements = doc.children();
    }

    public JXDocument(String html) {
        this.elements = Jsoup.parse((String)html).children();
    }

    public JXDocument(Elements els) {
        this.elements = els;
    }

    public List<Object> sel(String xpath) throws XpathSyntaxErrorException {
        LinkedList<Object> res = new LinkedList<Object>();
        try {
            List<JXNode> jns = this.xpathEva.xpathParser(xpath, this.elements);
            for (JXNode j : jns) {
                if (j.isText()) {
                    res.add(j.getTextVal());
                    continue;
                }
                res.add(j.getElement());
            }
        }
        catch (Exception e) {
            String msg = "please check the xpath syntax";
            if (e instanceof NoSuchAxisException || e instanceof NoSuchFunctionException) {
                msg = e.getMessage();
            }
            throw new XpathSyntaxErrorException(msg);
        }
        return res;
    }

    public List<JXNode> selN(String xpath) throws XpathSyntaxErrorException {
        try {
            return this.xpathEva.xpathParser(xpath, this.elements);
        }
        catch (Exception e) {
            String msg = "please check the xpath syntax";
            if (e instanceof NoSuchAxisException || e instanceof NoSuchFunctionException) {
                msg = e.getMessage();
            }
            throw new XpathSyntaxErrorException(msg);
        }
    }
}

