/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.role.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.config.api.InitConfigApi;
import cn.stylefeng.roses.kernel.db.api.context.DbOperatorContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.util.GunsResourceCodeUtil;
import cn.stylefeng.roses.kernel.system.api.ResourceServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleResourceDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleResource;
import cn.stylefeng.roses.kernel.system.modular.role.mapper.SysRoleResourceMapper;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleResourceService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleResourceServiceImpl
extends ServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements SysRoleResourceService {
    @Resource(name="roleResourceCacheApi")
    private CacheOperatorApi<List<String>> roleResourceCacheApi;
    @Resource
    private ResourceServiceApi resourceServiceApi;
    @Resource
    private InitConfigApi initConfigApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantResource(SysRoleRequest sysRoleRequest) {
        Long roleId = sysRoleRequest.getRoleId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
        List codeList = sysRoleRequest.getGrantResourceList();
        ArrayList<SysRoleResourceDTO> list = new ArrayList<SysRoleResourceDTO>();
        for (String resCode : codeList) {
            SysRoleResourceDTO sysRoleResourceDTO = new SysRoleResourceDTO();
            sysRoleResourceDTO.setResourceCode(resCode);
            list.add(sysRoleResourceDTO);
        }
        this.batchSaveResCodes(roleId, list);
    }

    @Override
    public void grantResourceV2(SysRoleRequest sysRoleRequest) {
        List selectedResource;
        List modularTotalResource = sysRoleRequest.getModularTotalResource();
        if (ObjectUtil.isNotEmpty((Object)modularTotalResource)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(SysRoleResource::getResourceCode, (Collection)modularTotalResource);
            wrapper.eq(SysRoleResource::getRoleId, (Object)sysRoleRequest.getRoleId());
            this.remove((Wrapper)wrapper);
        }
        if (ObjectUtil.isNotEmpty((Object)(selectedResource = sysRoleRequest.getSelectedResource()))) {
            ArrayList<SysRoleResource> sysRoleResources = new ArrayList<SysRoleResource>();
            for (String resourceCode : selectedResource) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(sysRoleRequest.getRoleId());
                sysRoleResource.setResourceCode(resourceCode);
                sysRoleResource.setResourceBizType(this.resourceServiceApi.getResourceBizTypeByCode(resourceCode));
                sysRoleResources.add(sysRoleResource);
            }
            this.saveBatch(sysRoleResources, sysRoleResources.size());
        }
        this.roleResourceCacheApi.remove(new String[]{String.valueOf(sysRoleRequest.getRoleId())});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByResourceIds(List<Long> resourceIds) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.select(new SFunction[]{SysRoleResource::getRoleId});
        wrapper1.in(SysRoleResource::getResourceCode, resourceIds);
        wrapper1.groupBy(SysRoleResource::getRoleId);
        List toGetRoles = this.list((Wrapper)wrapper1);
        List roleIds = toGetRoles.stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
        for (Long roleId : roleIds) {
            this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleResource::getResourceCode, resourceIds);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByRoleId(Long roleId, Integer resourceBizType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)resourceBizType), SysRoleResource::getResourceBizType, (Object)resourceBizType);
        this.remove((Wrapper)queryWrapper);
        this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
    }

    @Override
    public void quickSaveAll(List<SysRoleResource> sysRoleResourceList) {
        DbTypeEnum currentDbType = DbOperatorContext.me().getCurrentDbType();
        if (DbTypeEnum.MYSQL.equals((Object)currentDbType)) {
            List split = ListUtil.split(sysRoleResourceList, (int)100);
            for (List sysRoleResources : split) {
                ((SysRoleResourceMapper)this.getBaseMapper()).insertBatchSomeColumn(sysRoleResources);
            }
        } else {
            this.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
    }

    @Override
    public void batchSaveResCodes(Long roleId, List<SysRoleResourceDTO> totalResource) {
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        if (ObjectUtil.isNotEmpty(totalResource)) {
            for (SysRoleResourceDTO resCode : totalResource) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setResourceCode(resCode.getResourceCode());
                sysRoleResource.setResourceBizType(resCode.getResourceBizType());
                sysRoleResourceList.add(sysRoleResource);
            }
            DbTypeEnum currentDbType = DbOperatorContext.me().getCurrentDbType();
            if (DbTypeEnum.MYSQL.equals((Object)currentDbType)) {
                List split = ListUtil.split(sysRoleResourceList, (int)100);
                for (List sysRoleResources : split) {
                    ((SysRoleResourceMapper)this.getBaseMapper()).insertBatchSomeColumn(sysRoleResources);
                }
            } else {
                this.saveBatch(sysRoleResourceList);
            }
        }
    }

    @Override
    public void updateNewAppCode(Boolean decisionFirstStart, String newAppCode) {
        Boolean initConfigFlag;
        if (decisionFirstStart.booleanValue() && (initConfigFlag = this.initConfigApi.getInitConfigFlag()).booleanValue()) {
            return;
        }
        List list = this.list();
        for (SysRoleResource sysRoleResource : list) {
            String newResourceCode = GunsResourceCodeUtil.replace((String)sysRoleResource.getResourceCode(), (String)newAppCode);
            sysRoleResource.setResourceCode(newResourceCode);
        }
        this.updateBatchById(list);
    }
}

