/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.api.format;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.dsctn.api.context.CurrentDataSourceContext;
import cn.stylefeng.roses.kernel.rule.format.BaseSimpleFieldFormatProcess;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;

public class UserFormatProcess
extends BaseSimpleFieldFormatProcess {
    private static final String NOT_FIND_USER_NAME = "\u672a\u77e5\u4eba\u5458";

    public Class<?> getItemClass() {
        return Long.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object simpleItemFormat(Object businessId) {
        LoginUser loginUserNullable = LoginContext.me().getLoginUserNullable();
        if (loginUserNullable == null) {
            return this.execute(businessId);
        }
        try {
            String tenantCode = loginUserNullable.getTenantCode();
            if (StrUtil.isNotEmpty((CharSequence)tenantCode) && !"master".equals(tenantCode)) {
                CurrentDataSourceContext.setDataSourceName((String)("sys_tenant_db_" + tenantCode));
            }
            Object object = this.execute(businessId);
            return object;
        }
        finally {
            CurrentDataSourceContext.clearDataSourceName();
        }
    }

    private Object execute(Object businessId) {
        Long userId = Convert.toLong((Object)businessId);
        UserServiceApi bean = (UserServiceApi)SpringUtil.getBean(UserServiceApi.class);
        SysUserDTO userInfoByUserId = bean.getUserInfoByUserId(userId);
        if (userInfoByUserId == null) {
            return NOT_FIND_USER_NAME;
        }
        return userInfoByUserId.getRealName();
    }
}

