/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.devops;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.stylefeng.roses.kernel.jwt.JwtTokenOperator;
import cn.stylefeng.roses.kernel.jwt.api.pojo.config.JwtConfig;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.scanner.api.DevOpsReportApi;
import cn.stylefeng.roses.kernel.scanner.api.constants.ScannerConstants;
import cn.stylefeng.roses.kernel.scanner.api.exception.ScannerException;
import cn.stylefeng.roses.kernel.scanner.api.exception.enums.DevOpsExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.devops.DevOpsReportProperties;
import cn.stylefeng.roses.kernel.scanner.api.pojo.devops.DevOpsReportResourceParam;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.SysResourcePersistencePojo;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;

public class DefaultDevOpsReportImpl
implements DevOpsReportApi {
    public void reportResources(DevOpsReportProperties devOpsReportProperties, List<SysResourcePersistencePojo> sysResourcePersistencePojoList) {
        String serverHost = devOpsReportProperties.getServerHost();
        if (StrUtil.endWith((CharSequence)serverHost, (CharSequence)"/")) {
            serverHost = StrUtil.removeSuffix((CharSequence)serverHost, (CharSequence)"/");
        }
        String devopsReportUrl = serverHost + "/scannerResource/addExternalResource";
        String projectInteractionSecretKey = devOpsReportProperties.getProjectInteractionSecretKey();
        Long tokenValidityPeriodSeconds = devOpsReportProperties.getTokenValidityPeriodSeconds();
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setJwtSecret(projectInteractionSecretKey);
        jwtConfig.setExpiredSeconds(ObjectUtil.isNotEmpty((Object)tokenValidityPeriodSeconds) ? tokenValidityPeriodSeconds : ScannerConstants.DEVOPS_REPORT_TIMEOUT_SECONDS);
        JwtTokenOperator jwtTokenOperator = new JwtTokenOperator(jwtConfig);
        String jwtToken = jwtTokenOperator.generateToken(new HashMap());
        DevOpsReportResourceParam devOpsReportResourceParam = new DevOpsReportResourceParam(devOpsReportProperties.getProjectUniqueCode(), jwtToken, sysResourcePersistencePojoList, devOpsReportProperties.getFieldMetadataClassPath());
        HttpRequest httpRequest = HttpUtil.createPost((String)devopsReportUrl);
        httpRequest.body(JSON.toJSONString((Object)devOpsReportResourceParam));
        httpRequest.setConnectionTimeout(Convert.toInt((Object)(ScannerConstants.DEVOPS_REPORT_CONNECTION_TIMEOUT_SECONDS * 1000)).intValue());
        ResponseData responseData = null;
        HttpResponse execute = httpRequest.execute();
        String body = execute.body();
        responseData = (ResponseData)JSON.parseObject((String)body, ResponseData.class);
        if (responseData == null) {
            throw new ScannerException((AbstractExceptionEnum)DevOpsExceptionEnum.HTTP_RESPONSE_EMPTY);
        }
        if (!responseData.getSuccess().booleanValue()) {
            throw new ScannerException((AbstractExceptionEnum)DevOpsExceptionEnum.HTTP_RESPONSE_ERROR, new Object[]{responseData.getMessage()});
        }
    }
}

