/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.TypeUtil;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.scanner.api.annotation.field.ChineseDescription;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassReflectUtil {
    public static Set<FieldMetadata> getClassFieldDescription(Class<?> clazz) {
        Field[] declaredFields;
        HashSet<FieldMetadata> fieldDescriptions = new HashSet<FieldMetadata>();
        if (clazz == null) {
            return fieldDescriptions;
        }
        for (Field declaredField : declaredFields = ClassUtil.getDeclaredFields(clazz)) {
            Annotation[] annotations;
            Class genericClass;
            FieldMetadata fieldDescription = new FieldMetadata();
            fieldDescription.setMetadataId(IdUtil.fastSimpleUUID());
            String name = declaredField.getName();
            fieldDescription.setFieldName(name);
            Class<?> declaredFieldType = declaredField.getType();
            fieldDescription.setFieldClassType(declaredFieldType.getSimpleName());
            if (BaseRequest.class.isAssignableFrom(declaredFieldType)) {
                fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(declaredFieldType));
            }
            if (Collection.class.isAssignableFrom(declaredFieldType) && BaseRequest.class.isAssignableFrom(genericClass = TypeUtil.getClass((Type)TypeUtil.getTypeArgument((Type)TypeUtil.getType((Field)declaredField))))) {
                fieldDescription.setGenericFieldMetadata(ClassReflectUtil.getClassFieldDescription(genericClass));
            }
            if ((annotations = declaredField.getAnnotations()) != null && annotations.length > 0) {
                fieldDescription.setAnnotations(ClassReflectUtil.annotationsToStrings(annotations));
                HashMap<String, Set<String>> groupAnnotations = new HashMap<String, Set<String>>();
                for (Annotation annotation : annotations) {
                    Class[] validateGroupsClasses = ClassReflectUtil.invokeAnnotationMethodIgnoreError(annotation, "groups", Class[].class);
                    if (validateGroupsClasses == null) continue;
                    for (Class validateGroupsClass : validateGroupsClasses) {
                        ClassReflectUtil.addGroupValidateAnnotation(annotation, validateGroupsClass, groupAnnotations);
                    }
                }
                fieldDescription.setGroupValidationMessage(groupAnnotations);
                ChineseDescription chineseDescription = declaredField.getAnnotation(ChineseDescription.class);
                if (chineseDescription != null) {
                    fieldDescription.setChineseName(chineseDescription.value());
                }
            }
            fieldDescriptions.add(fieldDescription);
        }
        return fieldDescriptions;
    }

    private static <T> T invokeAnnotationMethodIgnoreError(Annotation apiResource, String methodName, Class<T> resultType) {
        try {
            Class<? extends Annotation> annotationType = apiResource.annotationType();
            Method method = annotationType.getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)apiResource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static void addGroupValidateAnnotation(Annotation fieldAnnotation, Class<?> validateGroupsClass, Map<String, Set<String>> groupAnnotations) {
        Set<String> annotations = groupAnnotations.get(validateGroupsClass.getSimpleName());
        if (annotations == null) {
            annotations = new HashSet<String>();
        }
        String messageTip = ClassReflectUtil.invokeAnnotationMethodIgnoreError(fieldAnnotation, "message", String.class);
        annotations.add(messageTip);
        groupAnnotations.put(validateGroupsClass.getSimpleName(), annotations);
    }

    private static Set<String> annotationsToStrings(Annotation[] annotations) {
        HashSet<String> strings = new HashSet<String>();
        if (annotations == null || annotations.length == 0) {
            return strings;
        }
        for (Annotation annotation : annotations) {
            strings.add(annotation.annotationType().getSimpleName());
        }
        return strings;
    }
}

