/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.modular.controller;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.message.api.MessageApi;
import cn.stylefeng.roses.kernel.message.api.enums.MessageReadFlagEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageRequest;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageSendRequest;
import cn.stylefeng.roses.kernel.message.api.pojo.response.MessageResponse;
import cn.stylefeng.roses.kernel.rule.annotation.BusinessLog;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u7cfb\u7edf\u6d88\u606f\u63a7\u5236\u5668", resBizType=ResBizTypeEnum.SYSTEM)
public class SysMessageController {
    @Resource
    private MessageApi messageApi;

    @PostResource(name="\u53d1\u9001\u7cfb\u7edf\u6d88\u606f", path={"/sysMessage/sendMessage"})
    @BusinessLog
    public ResponseData<?> sendMessage(@RequestBody @Validated(value={BaseRequest.add.class}) MessageSendRequest messageSendRequest) {
        messageSendRequest.setMessageSendTime(new Date());
        this.messageApi.sendMessage(messageSendRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u6279\u91cf\u66f4\u65b0\u7cfb\u7edf\u6d88\u606f\u72b6\u6001", path={"/sysMessage/batchUpdateReadFlag"})
    @BusinessLog
    public ResponseData<?> batchUpdateReadFlag(@RequestBody @Validated(value={MessageRequest.updateReadFlag.class}) MessageRequest messageRequest) {
        List messageIdList = messageRequest.getMessageIdList();
        this.messageApi.batchReadFlagByMessageIds(StrUtil.join((CharSequence)",", (Iterable)messageIdList), MessageReadFlagEnum.READ);
        return new SuccessResponseData();
    }

    @GetResource(name="\u7cfb\u7edf\u6d88\u606f\u5168\u90e8\u4fee\u6539\u5df2\u8bfb", path={"/sysMessage/allMessageReadFlag"})
    public ResponseData<?> allMessageReadFlag() {
        this.messageApi.allMessageReadFlag();
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664\u7cfb\u7edf\u6d88\u606f", path={"/sysMessage/delete"})
    @BusinessLog
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) MessageRequest messageRequest) {
        this.messageApi.deleteByMessageId(messageRequest.getMessageId());
        return new SuccessResponseData();
    }

    @GetResource(name="\u67e5\u770b\u7cfb\u7edf\u6d88\u606f", path={"/sysMessage/detail"})
    public ResponseData<MessageResponse> detail(@Validated(value={BaseRequest.detail.class}) MessageRequest messageRequest) {
        return new SuccessResponseData((Object)this.messageApi.messageDetail(messageRequest));
    }

    @GetResource(name="\u5206\u9875\u67e5\u8be2\u7cfb\u7edf\u6d88\u606f\u5217\u8868", path={"/sysMessage/page"})
    public ResponseData<PageResult<MessageResponse>> page(MessageRequest messageRequest) {
        return new SuccessResponseData((Object)this.messageApi.queryPageCurrentUser(messageRequest));
    }

    @GetResource(name="\u7cfb\u7edf\u6d88\u606f\u5217\u8868", path={"/sysMessage/list"})
    public ResponseData<List<MessageResponse>> list(MessageRequest messageRequest) {
        return new SuccessResponseData((Object)this.messageApi.queryListCurrentUser(messageRequest));
    }

    @GetResource(name="\u67e5\u8be2\u6240\u6709\u672a\u8bfb\u7cfb\u7edf\u6d88\u606f\u5217\u8868", path={"/sysMessage/unReadMessageList"}, requiredPermission=false)
    public ResponseData<List<MessageResponse>> unReadMessageList(MessageRequest messageRequest) {
        messageRequest.setReadFlag(MessageReadFlagEnum.UNREAD.getCode());
        List messageResponses = this.messageApi.queryListCurrentUser(messageRequest);
        return new SuccessResponseData((Object)messageResponses);
    }
}

