/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.constants.DictConstants;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.dict.modular.service.DictTypeService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, SysDict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private PinYinApi pinYinApi;
    @Resource
    private DictTypeService dictTypeService;
    @Resource(name="defaultStringCacheOperator")
    private CacheOperatorApi<String> defaultStringCacheOperator;
    private static final String CACHE_PREFIX = "dict:";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DictRequest dictRequest) {
        this.validateRepeat(dictRequest, false);
        SysDict sysDict = new SysDict();
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)sysDict), (String[])new String[0]);
        sysDict.setDictParentId(DictConstants.DEFAULT_DICT_PARENT_ID);
        sysDict.setDictPids("[" + DictConstants.DEFAULT_DICT_PARENT_ID + "]" + ",");
        sysDict.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDict.getDictName()));
        this.save((Object)sysDict);
    }

    @Override
    public void del(DictRequest dictRequest) {
        SysDict sysDict = this.querySysDict(dictRequest);
        sysDict.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysDict);
        this.defaultStringCacheOperator.remove(new String[]{CACHE_PREFIX + sysDict.getDictTypeCode() + "|" + sysDict.getDictCode()});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(DictRequest dictRequest) {
        this.validateRepeat(dictRequest, true);
        SysDict sysDict = this.querySysDict(dictRequest);
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)sysDict), (String[])new String[0]);
        sysDict.setDictTypeCode(null);
        sysDict.setDictCode(null);
        sysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDict.getDictName()));
        this.updateById((Object)sysDict);
        this.defaultStringCacheOperator.remove(new String[]{CACHE_PREFIX + sysDict.getDictTypeCode() + "|" + sysDict.getDictCode()});
    }

    @Override
    public SysDict detail(DictRequest dictRequest) {
        return (SysDict)((Object)this.getOne((Wrapper)this.createWrapper(dictRequest), false));
    }

    @Override
    public List<SysDict> findList(DictRequest dictRequest) {
        return this.list((Wrapper)this.createWrapper(dictRequest));
    }

    @Override
    public PageResult<SysDict> findPage(DictRequest dictRequest) {
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)this.createWrapper(dictRequest));
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<TreeDictInfo> getTreeDictList(DictRequest dictRequest) {
        List<SysDict> sysDictList = this.findList(dictRequest);
        if (sysDictList == null || sysDictList.isEmpty()) {
            return new ArrayList<TreeDictInfo>();
        }
        ArrayList<TreeDictInfo> treeDictInfos = new ArrayList<TreeDictInfo>();
        for (SysDict sysDict : sysDictList) {
            TreeDictInfo treeDictInfo = new TreeDictInfo();
            treeDictInfo.setDictId(sysDict.getDictId());
            treeDictInfo.setDictCode(sysDict.getDictCode());
            treeDictInfo.setDictParentId(sysDict.getDictParentId());
            treeDictInfo.setDictName(sysDict.getDictName());
            treeDictInfos.add(treeDictInfo);
        }
        return new DefaultTreeBuildFactory().doTreeBuild(treeDictInfos);
    }

    public String getDictName(String dictTypeCode, String dictCode) {
        String dictName = (String)this.defaultStringCacheOperator.get(CACHE_PREFIX + dictTypeCode + "|" + dictCode);
        if (StrUtil.isNotEmpty((CharSequence)dictName)) {
            return dictName;
        }
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeCode, (Object)dictTypeCode);
        sysDictLambdaQueryWrapper.eq(SysDict::getDictCode, (Object)dictCode);
        sysDictLambdaQueryWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        List list = this.list((Wrapper)sysDictLambdaQueryWrapper);
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() > 1) {
            log.error(DictExceptionEnum.DICT_CODE_REPEAT.getUserTip(), (Object)"", (Object)dictCode);
            return "";
        }
        dictName = ((SysDict)((Object)list.get(0))).getDictName();
        this.defaultStringCacheOperator.put(CACHE_PREFIX + dictTypeCode + "|" + dictCode, (Object)dictName);
        if (dictName != null) {
            return dictName;
        }
        return "";
    }

    public List<SimpleDict> getDictDetailsByDictTypeCode(String dictTypeCode) {
        DictRequest dictRequest = new DictRequest();
        dictRequest.setDictTypeCode(dictTypeCode);
        LambdaQueryWrapper<SysDict> wrapper = this.createWrapper(dictRequest);
        List dictList = this.list((Wrapper)wrapper);
        if (dictList.isEmpty()) {
            return new ArrayList<SimpleDict>();
        }
        ArrayList<SimpleDict> simpleDictList = new ArrayList<SimpleDict>();
        for (SysDict sysDict : dictList) {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setCode(sysDict.getDictCode());
            simpleDict.setName(sysDict.getDictName());
            simpleDictList.add(simpleDict);
        }
        return simpleDictList;
    }

    public void deleteByDictId(Long dictId) {
        this.removeById(dictId);
    }

    private SysDict querySysDict(DictRequest dictRequest) {
        SysDict sysDict = (SysDict)((Object)this.getById(dictRequest.getDictId()));
        if (ObjectUtil.isNull((Object)((Object)sysDict))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_NOT_EXISTED, new Object[]{dictRequest.getDictId()});
        }
        return sysDict;
    }

    private LambdaQueryWrapper<SysDict> createWrapper(DictRequest dictRequest) {
        SysDictType sysDictType;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)dictRequest.getDictTypeId()) && (sysDictType = (SysDictType)((Object)this.dictTypeService.getById(dictRequest.getDictTypeId()))) != null) {
            dictRequest.setDictTypeCode(sysDictType.getDictTypeCode());
        }
        queryWrapper.eq(ObjectUtil.isNotNull((Object)dictRequest.getDictId()), SysDict::getDictId, (Object)dictRequest.getDictId());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)dictRequest.getDictTypeCode()), SysDict::getDictTypeCode, (Object)dictRequest.getDictTypeCode());
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)dictRequest.getDictCode()), SysDict::getDictCode, (Object)dictRequest.getDictCode());
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)dictRequest.getDictName()), SysDict::getDictName, (Object)dictRequest.getDictName());
        queryWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        return queryWrapper;
    }

    private void validateRepeat(DictRequest dictRequest, boolean editFlag) {
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeCode, (Object)dictRequest.getDictTypeCode());
        sysDictLambdaQueryWrapper.eq(SysDict::getDictCode, (Object)dictRequest.getDictCode());
        if (editFlag) {
            sysDictLambdaQueryWrapper.ne(SysDict::getDictId, (Object)dictRequest.getDictId());
        }
        sysDictLambdaQueryWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        long count = this.count((Wrapper)sysDictLambdaQueryWrapper);
        if (count > 0L) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_CODE_REPEAT, new Object[]{dictRequest.getDictTypeCode(), dictRequest.getDictCode()});
        }
        LambdaQueryWrapper dictNameWrapper = new LambdaQueryWrapper();
        dictNameWrapper.eq(SysDict::getDictTypeCode, (Object)dictRequest.getDictTypeCode());
        dictNameWrapper.eq(SysDict::getDictName, (Object)dictRequest.getDictName());
        if (editFlag) {
            dictNameWrapper.ne(SysDict::getDictId, (Object)dictRequest.getDictId());
        }
        dictNameWrapper.ne(SysDict::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        long dictNameCount = this.count((Wrapper)dictNameWrapper);
        if (dictNameCount > 0L) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_NAME_REPEAT, new Object[]{dictRequest.getDictTypeCode(), dictRequest.getDictCode()});
        }
    }
}

