/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.web.servlet.wrapper;

import cn.orionsec.kit.lang.utils.Xsses;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Set<String> ignoreFields;

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        this.ignoreFields = Collections.emptySet();
    }

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String fields) {
        super(servletRequest);
        String[] fieldArr;
        this.ignoreFields = new HashSet<String>();
        for (String f : fieldArr = fields.split(",")) {
            this.ignoreFields.add(f.trim());
        }
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.ignoreFields.contains(parameter) ? Xsses.clean((String)values[i]) : values[i];
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        if (this.ignoreFields.contains(parameter)) {
            return Xsses.clean((String)value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return Xsses.clean((String)value);
    }
}

