/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.web.servlet.wrapper;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.web.servlet.web.Servlets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CacheServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public CacheServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.body = this.readBody(request);
    }

    private byte[] readBody(HttpServletRequest request) {
        try {
            return Servlets.getBody(request);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int available() {
                return CacheServletRequestWrapper.this.body.length;
            }
        };
    }
}

