/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.web.servlet.web;

import cn.orionsec.kit.lang.define.collect.MutableHashMap;
import cn.orionsec.kit.lang.define.mutable.MutableString;
import cn.orionsec.kit.lang.define.wrapper.HttpWrapper;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Urls;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.net.IPs;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlets {
    private static final String USER_AGENT = "User-Agent";
    private static final String[] REMOTE_ADDR_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "X-Real-IP"};

    private Servlets() {
    }

    public static MutableString getParameter(HttpServletRequest request, String key) {
        return new MutableString(request.getParameter(key));
    }

    public static MutableHashMap<String, String> getParameters(HttpServletRequest request, String ... keys) {
        MutableHashMap map = new MutableHashMap();
        for (String key : keys) {
            map.put((Object)key, (Object)request.getParameter(key));
        }
        return map;
    }

    public static MutableHashMap<String, String> getParameterMap(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        MutableHashMap map = new MutableHashMap();
        for (Map.Entry es : parameterMap.entrySet()) {
            map.put(es.getKey(), (Object)((String[])es.getValue())[0]);
        }
        return map;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader(USER_AGENT);
    }

    public static MutableString getHeader(HttpServletRequest request, String key) {
        return new MutableString(request.getHeader(key));
    }

    public static MutableHashMap<String, String> getHeaders(HttpServletRequest request, String ... keys) {
        MutableHashMap map = new MutableHashMap();
        for (String key : keys) {
            map.put((Object)key, (Object)request.getHeader(key));
        }
        return map;
    }

    public static MutableHashMap<String, String> getHeaderMap(HttpServletRequest request) {
        MutableHashMap map = new MutableHashMap();
        Enumeration it = request.getHeaderNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            map.put((Object)key, (Object)request.getHeader(key));
        }
        return map;
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        for (String remoteAddrHeader : REMOTE_ADDR_HEADERS) {
            String addr = Servlets.checkRemoteAddr(request.getHeader(remoteAddrHeader));
            if (addr == null) continue;
            return addr;
        }
        return Servlets.checkRemoteAddr(request.getRemoteAddr());
    }

    private static String checkRemoteAddr(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        headerValue = headerValue.split(",")[0];
        return IPs.checkIp((String)headerValue);
    }

    public static String getMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static MutableHashMap<String, String> getQueryStringMap(HttpServletRequest request) {
        return Urls.getQueryString((String)request.getQueryString());
    }

    public static String getRequestUri(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public static String getRequestUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public static String getProtocol(HttpServletRequest request) {
        return request.getProtocol();
    }

    public static String getScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    public static int getContentLength(HttpServletRequest request) {
        return request.getContentLength();
    }

    public static long getContentLengthLong(HttpServletRequest request) {
        return request.getContentLengthLong();
    }

    public static String getContentType(HttpServletRequest request) {
        return request.getContentType();
    }

    public static String getCharset(HttpServletRequest request) {
        return request.getCharacterEncoding();
    }

    public static String getApplicationAddr(HttpServletRequest request) {
        return request.getLocalAddr();
    }

    public static String getApplicationName(HttpServletRequest request) {
        return request.getLocalName();
    }

    public static int getApplicationPort(HttpServletRequest request) {
        return request.getLocalPort();
    }

    public static String getRequestAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public static String getRequestHost(HttpServletRequest request) {
        return request.getRemoteHost();
    }

    public static int getRequestPort(HttpServletRequest request) {
        return request.getRemotePort();
    }

    public static String getServerName(HttpServletRequest request) {
        return request.getServerName();
    }

    public static int getServerPort(HttpServletRequest request) {
        return request.getServerPort();
    }

    public static BufferedReader getReader(HttpServletRequest request) throws IOException {
        return request.getReader();
    }

    public static ServletInputStream getInputStream(HttpServletRequest request) throws IOException {
        return request.getInputStream();
    }

    public static byte[] getBody(HttpServletRequest request) throws IOException {
        return Streams.toByteArray((InputStream)request.getInputStream());
    }

    public static void redirect(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(url);
    }

    public static String getUserAgent(HttpServletResponse response) {
        return response.getHeader(USER_AGENT);
    }

    public static String getContentType(HttpServletResponse response) {
        return response.getHeader("Content-Type");
    }

    public static MutableString getHeader(HttpServletResponse response, String key) {
        return new MutableString(response.getHeader(key));
    }

    public static MutableHashMap<String, String> getHeaders(HttpServletResponse response, String ... keys) {
        MutableHashMap map = new MutableHashMap();
        for (String key : keys) {
            map.put((Object)key, (Object)response.getHeader(key));
        }
        return map;
    }

    public static MutableHashMap<String, String> getHeaderMap(HttpServletResponse response) {
        MutableHashMap map = new MutableHashMap();
        Collection headerNames = response.getHeaderNames();
        for (String headerName : headerNames) {
            map.put((Object)headerName, (Object)response.getHeader(headerName));
        }
        return map;
    }

    public static void setHeader(HttpServletResponse response, String key, String value) {
        response.setHeader(key, value);
    }

    public static void setHeaders(HttpServletResponse response, Map<String, String> handler) {
        for (Map.Entry<String, String> entry : handler.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static int getStatus(HttpServletResponse response) {
        return response.getStatus();
    }

    public static void getStatus(HttpServletResponse response, int status) {
        response.setStatus(status);
    }

    public static void setContentLength(HttpServletResponse response, int length) {
        response.setContentLength(length);
    }

    public static void setContentLengthLong(HttpServletResponse response, long length) {
        response.setContentLengthLong(length);
    }

    public static void setContentType(HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
    }

    public static void setCharset(HttpServletResponse response, String charset) {
        response.setCharacterEncoding(charset);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IOException {
        return response.getWriter();
    }

    public static ServletOutputStream getOutputStream(HttpServletResponse response) throws IOException {
        return response.getOutputStream();
    }

    public static void transfer(HttpServletResponse response, byte[] bs) throws IOException {
        Streams.transfer((InputStream)Streams.toInputStream((byte[])bs), (OutputStream)response.getOutputStream());
    }

    public static void transfer(HttpServletResponse response, byte[] bs, String fileName) throws IOException {
        Servlets.setAttachmentHeader(response, fileName);
        Streams.transfer((InputStream)Streams.toInputStream((byte[])bs), (OutputStream)response.getOutputStream());
    }

    public static void transfer(HttpServletResponse response, InputStream in) throws IOException {
        Streams.transfer((InputStream)in, (OutputStream)response.getOutputStream());
    }

    public static void transfer(HttpServletResponse response, InputStream in, String fileName) throws IOException {
        Servlets.setAttachmentHeader(response, fileName);
        Streams.transfer((InputStream)in, (OutputStream)response.getOutputStream());
    }

    public static void transfer(HttpServletResponse response, Reader reader) throws IOException {
        Streams.transfer((Reader)reader, (Writer)response.getWriter());
    }

    public static void transfer(HttpServletResponse response, Reader reader, String fileName) throws IOException {
        Servlets.setAttachmentHeader(response, fileName);
        Streams.transfer((Reader)reader, (Writer)response.getWriter());
    }

    public static void setAttachmentHeader(HttpServletResponse response, String fileName) {
        response.setContentType("application/octet-stream");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unsupportedEncoding((Throwable)e);
        }
    }

    public static void writeJson(HttpServletResponse response, Object o) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        Servlets.transfer(response, JSON.toJSONBytes((Object)o));
    }

    public static void writeHttpWrapper(HttpServletResponse response, HttpWrapper<?> wrapper) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        Servlets.transfer(response, wrapper.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    public static void cross(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, X-Requested-With, Accept, Origin, Last-Modified");
        response.setHeader("Access-Control-Max-Age", "86400");
    }
}

