/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.spring;

import cn.orionsec.kit.lang.utils.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringHolder.class);
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;

    private SpringHolder() {
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        return beanFactory;
    }

    public static void publishEvent(ApplicationEvent event) {
        applicationContext.publishEvent(event);
    }

    public static void publishEvent(Object event) {
        applicationContext.publishEvent(event);
    }

    public static <T> T getBean(String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> type) {
        return (T)applicationContext.getBean(type);
    }

    public static <T> T getBean(String beanName, Class<T> type) {
        return (T)applicationContext.getBean(beanName, type);
    }

    public static boolean containsBean(String beanName) {
        return applicationContext.containsBean(beanName);
    }

    public static String[] getBeanNames() {
        return applicationContext.getBeanDefinitionNames();
    }

    public static boolean isSingletonBean(String beanName) {
        return applicationContext.isSingleton(beanName);
    }

    public static Class<?> getType(String beanName) {
        return applicationContext.getType(beanName);
    }

    public static boolean isType(String beanName, Class<?> beanType) {
        return applicationContext.isTypeMatch(beanName, beanType);
    }

    public static String[] getBeanAliases(String beanName) {
        return applicationContext.getAliases(beanName);
    }

    public static void close() {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).close();
        }
    }

    public static void refresh() {
        Valid.isInstanceOf((Object)applicationContext, ConfigurableApplicationContext.class);
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringHolder.applicationContext;
        applicationContext.refresh();
    }

    public static class ApplicationContextAwareStore
    implements ApplicationContextAware,
    BeanFactoryPostProcessor {
        public ApplicationContextAwareStore() {
            LOGGER.info("init spring holder");
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            LOGGER.info("inject spring holder ApplicationContext");
            applicationContext = applicationContext;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
            LOGGER.info("inject spring holder BeanFactory");
            beanFactory = configurableListableBeanFactory;
        }
    }
}

