/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.support;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public abstract class SplitTargetGenerator
implements SafeCloseable {
    protected List<OutputStream> targets;
    protected String generatorPathDir;
    protected String generatorBaseName;
    protected String generatorNameSuffix;
    protected int currentTargetIndex;
    protected String suffix;
    protected boolean autoClose;
    protected OutputStream currentOutputStream;

    public SplitTargetGenerator autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public SplitTargetGenerator target(OutputStream ... target) {
        Valid.notEmpty((Object[])target, (String)"target file is empty", (Object[])new Object[0]);
        this.targets = Lists.of((Object[])target);
        this.generatorPathDir = null;
        this.generatorBaseName = null;
        return this;
    }

    public SplitTargetGenerator target(File ... target) {
        Valid.notEmpty((Object[])target, (String)"target file is empty", (Object[])new Object[0]);
        OutputStream[] streams = (OutputStream[])Arrays.stream(target).map(Files1::openOutputStreamSafe).toArray(OutputStream[]::new);
        return this.target(streams);
    }

    public SplitTargetGenerator target(String ... target) {
        Valid.notEmpty((Object[])target, (String)"target file is empty", (Object[])new Object[0]);
        OutputStream[] streams = (OutputStream[])Arrays.stream(target).map(Files1::openOutputStreamSafe).toArray(OutputStream[]::new);
        return this.target(streams);
    }

    public SplitTargetGenerator targetPath(String pathDir, String baseName) {
        return this.targetPath(pathDir, baseName, null);
    }

    public SplitTargetGenerator targetPath(String pathDir, String baseName, String nameSuffix) {
        Valid.notNull((Object)pathDir, (String)"target path dir is null", (Object[])new Object[0]);
        Valid.notNull((Object)baseName, (String)"target file base name is null", (Object[])new Object[0]);
        this.targets = null;
        this.generatorPathDir = pathDir;
        this.generatorBaseName = baseName;
        this.generatorNameSuffix = Strings.def((String)nameSuffix);
        this.autoClose = true;
        return this;
    }

    protected OutputStream generatorOutputStream() {
        String path = Files1.getPath((String)(this.generatorPathDir + "/" + this.generatorBaseName + this.generatorNameSuffix + ++this.currentTargetIndex + "." + this.suffix));
        Files1.touch((String)path);
        return Files1.openOutputStreamSafe((String)path);
    }

    protected boolean hasNext() {
        if (this.targets == null) {
            return true;
        }
        return this.targets.size() > this.currentTargetIndex;
    }

    protected void next() {
        this.currentOutputStream = this.hasNext() ? (this.targets == null ? this.generatorOutputStream() : this.targets.get(this.currentTargetIndex++)) : null;
    }

    public void close() {
        if (this.autoClose && this.targets != null) {
            this.targets.forEach(Streams::close);
        }
    }
}

