/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.writer.exporting;

import cn.orionsec.kit.lang.able.Analysable;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.reflect.Annotations;
import cn.orionsec.kit.office.excel.annotation.ExportFooter;
import cn.orionsec.kit.office.excel.annotation.ExportHeader;
import cn.orionsec.kit.office.excel.annotation.ExportMeta;
import cn.orionsec.kit.office.excel.annotation.ExportPrint;
import cn.orionsec.kit.office.excel.annotation.ExportSheet;
import cn.orionsec.kit.office.excel.annotation.ExportTitle;
import cn.orionsec.kit.office.excel.option.FontOption;
import cn.orionsec.kit.office.excel.option.FooterOption;
import cn.orionsec.kit.office.excel.option.HeaderOption;
import cn.orionsec.kit.office.excel.option.PrintOption;
import cn.orionsec.kit.office.excel.option.PropertiesOption;
import cn.orionsec.kit.office.excel.option.TitleOption;
import cn.orionsec.kit.office.excel.writer.exporting.SheetColumnAnalysis;
import cn.orionsec.kit.office.excel.writer.exporting.SheetConfig;

public class SheetAnalysis<T>
implements Analysable {
    private final Class<T> targetClass;
    private final SheetConfig<T> sheetConfig;

    public SheetAnalysis(Class<T> targetClass, SheetConfig<T> sheetConfig) {
        this.targetClass = targetClass;
        this.sheetConfig = sheetConfig;
    }

    public void analysis() {
        this.analysisSheet();
        this.analysisTitle();
        this.analysisHeader();
        this.analysisFooter();
        this.analysisPrint();
        this.analysisProperties();
    }

    private void analysisSheet() {
        int rowHeight;
        int headerHeight;
        int titleHeight;
        int defaultHeight;
        ExportSheet sheet = (ExportSheet)Annotations.getAnnotation(this.targetClass, ExportSheet.class);
        if (sheet == null) {
            throw Exceptions.parse((String)"the exported class cannot be parsed because an @ExportSheet was not found");
        }
        String sheetName = sheet.name();
        if (!Strings.isEmpty((CharSequence)sheetName)) {
            this.sheetConfig.sheetOption.setName(sheetName);
        }
        this.sheetConfig.sheetOption.setHeaderUseColumnStyle(sheet.headerUseColumnStyle());
        this.sheetConfig.sheetOption.setColumnUseDefaultStyle(sheet.columnUseDefaultStyle());
        this.sheetConfig.sheetOption.setIndexToSort(sheet.indexToSort());
        int width = sheet.columnWidth();
        if (width != -1) {
            this.sheetConfig.sheetOption.setColumnWidth(width);
        }
        if ((defaultHeight = sheet.height()) != -1) {
            this.sheetConfig.sheetOption.setTitleHeight(defaultHeight);
            this.sheetConfig.sheetOption.setHeaderHeight(defaultHeight);
            this.sheetConfig.sheetOption.setRowHeight(defaultHeight);
        }
        if ((titleHeight = sheet.titleHeight()) != -1) {
            this.sheetConfig.sheetOption.setTitleHeight(titleHeight);
        }
        if ((headerHeight = sheet.headerHeight()) != -1) {
            this.sheetConfig.sheetOption.setHeaderHeight(headerHeight);
        }
        if ((rowHeight = sheet.rowHeight()) != -1) {
            this.sheetConfig.sheetOption.setRowHeight(rowHeight);
        }
        if (sheet.zoom() != -1) {
            this.sheetConfig.sheetOption.setZoom(sheet.zoom());
        }
        this.sheetConfig.sheetOption.setSkipFieldHeader(sheet.skipFieldHeader());
        this.sheetConfig.sheetOption.setSkipComment(sheet.skipComment());
        this.sheetConfig.sheetOption.setSkipLink(sheet.skipLink());
        this.sheetConfig.sheetOption.setSkipPicture(sheet.skipPicture());
        this.sheetConfig.sheetOption.setSkipPictureException(sheet.skipPictureException());
        this.sheetConfig.sheetOption.setSkipSelectOption(sheet.skipSelectOption());
        this.sheetConfig.sheetOption.setFreezeHeader(sheet.freezeHeader());
        this.sheetConfig.sheetOption.setFilterHeader(sheet.filterHeader());
        this.sheetConfig.sheetOption.setSelected(sheet.selected());
        this.sheetConfig.sheetOption.setHidden(sheet.hidden());
        this.sheetConfig.sheetOption.setDisplayGridLines(sheet.displayGridLines());
        this.sheetConfig.sheetOption.setDisplayRowColHeadings(sheet.displayRowColHeadings());
        this.sheetConfig.sheetOption.setDisplayFormulas(sheet.displayFormulas());
    }

    private void analysisTitle() {
        ExportTitle title = (ExportTitle)Annotations.getAnnotation(this.targetClass, ExportTitle.class);
        if (title == null) {
            return;
        }
        TitleOption titleOption = new TitleOption();
        titleOption.setTitle(title.title());
        titleOption.setUseRow(title.useRow());
        titleOption.setUseColumn(title.useColumn());
        titleOption.setVerticalAlign(title.verticalAlign());
        titleOption.setAlign(title.align());
        String backgroundColor = title.backgroundColor();
        if (!Strings.isEmpty((CharSequence)backgroundColor)) {
            titleOption.setBackgroundColor(backgroundColor);
        }
        titleOption.setBorder(title.border());
        String borderColor = title.borderColor();
        if (!Strings.isEmpty((CharSequence)borderColor)) {
            titleOption.setBorderColor(borderColor);
        }
        FontOption fontOption = SheetColumnAnalysis.parseFont(title.font());
        titleOption.setFont(fontOption);
        this.sheetConfig.sheetOption.setTitleOption(titleOption);
    }

    private void analysisHeader() {
        ExportHeader header = (ExportHeader)Annotations.getAnnotation(this.targetClass, ExportHeader.class);
        if (header == null) {
            return;
        }
        HeaderOption headerOption = new HeaderOption();
        headerOption.setLeft(header.left());
        headerOption.setCenter(header.center());
        headerOption.setRight(header.right());
        this.sheetConfig.sheetOption.setHeaderOption(headerOption);
    }

    private void analysisFooter() {
        ExportFooter footer = (ExportFooter)Annotations.getAnnotation(this.targetClass, ExportFooter.class);
        if (footer == null) {
            return;
        }
        FooterOption footerOption = new FooterOption();
        footerOption.setLeft(footer.left());
        footerOption.setCenter(footer.center());
        footerOption.setRight(footer.right());
        this.sheetConfig.sheetOption.setFooterOption(footerOption);
    }

    private void analysisPrint() {
        int[] repeat;
        int limit;
        double footerMargin;
        double headerMargin;
        double bottomMargin;
        double topMargin;
        double rightMargin;
        double leftMargin;
        int height;
        int width;
        int verticalResolution;
        ExportPrint print = (ExportPrint)Annotations.getAnnotation(this.targetClass, ExportPrint.class);
        if (print == null) {
            return;
        }
        PrintOption printOption = new PrintOption();
        printOption.setPrintGridLines(print.printGridLines());
        printOption.setPrintRowHeading(print.printHeading());
        printOption.setFit(print.fit());
        printOption.setHorizontallyCenter(print.horizontallyCenter());
        printOption.setVerticallyCenter(print.verticallyCenter());
        printOption.setPaper(print.paper());
        printOption.setColor(print.color());
        printOption.setLandScapePrint(print.landScapePrint());
        printOption.setSetPrintOrientation(print.setPrintOrientation());
        printOption.setScale(print.scale());
        printOption.setNotes(print.notes());
        printOption.setUsePage(print.usePage());
        printOption.setPageStart(print.pageStart());
        printOption.setCopies(print.copies());
        printOption.setDraft(print.draft());
        printOption.setTopToBottom(print.topToBottom());
        int horizontalResolution = print.horizontalResolution();
        if (horizontalResolution != -1) {
            printOption.setHorizontalResolution(horizontalResolution);
        }
        if ((verticalResolution = print.verticalResolution()) != -1) {
            printOption.setVerticalResolution(verticalResolution);
        }
        if ((width = print.width()) != -1) {
            printOption.setWidth(width);
        }
        if ((height = print.height()) != -1) {
            printOption.setHeight(height);
        }
        if ((leftMargin = print.leftMargin()) != -1.0) {
            printOption.setLeftMargin(leftMargin);
        }
        if ((rightMargin = print.rightMargin()) != -1.0) {
            printOption.setRightMargin(rightMargin);
        }
        if ((topMargin = print.topMargin()) != -1.0) {
            printOption.setTopMargin(topMargin);
        }
        if ((bottomMargin = print.bottomMargin()) != -1.0) {
            printOption.setBottomMargin(bottomMargin);
        }
        if ((headerMargin = print.headerMargin()) != -1.0) {
            printOption.setHeaderMargin(headerMargin);
        }
        if ((footerMargin = print.footerMargin()) != -1.0) {
            printOption.setFooterMargin(footerMargin);
        }
        if ((limit = print.limit()) != -1) {
            printOption.setAutoLimit(true);
            printOption.setLimit(limit);
        }
        if ((repeat = print.repeat()).length != 0) {
            printOption.setRepeat(repeat);
        }
        this.sheetConfig.sheetOption.setPrintOption(printOption);
    }

    private void analysisProperties() {
        PropertiesOption propertiesOption = new PropertiesOption();
        this.sheetConfig.sheetOption.setPropertiesOption(propertiesOption);
        ExportMeta meta = (ExportMeta)Annotations.getAnnotation(this.targetClass, ExportMeta.class);
        if (meta == null) {
            return;
        }
        Strings.ifNotBlank((String)meta.author(), propertiesOption::setAuthor);
        Strings.ifNotBlank((String)meta.title(), propertiesOption::setTitle);
        Strings.ifNotBlank((String)meta.subject(), propertiesOption::setSubject);
        Strings.ifNotBlank((String)meta.keywords(), propertiesOption::setKeywords);
        Strings.ifNotBlank((String)meta.revision(), propertiesOption::setRevision);
        Strings.ifNotBlank((String)meta.description(), propertiesOption::setDescription);
        Strings.ifNotBlank((String)meta.category(), propertiesOption::setCategory);
        Strings.ifNotBlank((String)meta.company(), propertiesOption::setCompany);
        Strings.ifNotBlank((String)meta.manager(), propertiesOption::setManager);
        Strings.ifNotBlank((String)meta.application(), propertiesOption::setApplication);
        Strings.ifNotBlank((String)meta.modifiedUser(), propertiesOption::setModifiedUser);
        Strings.ifNotBlank((String)meta.contentStatus(), propertiesOption::setContentStatus);
        Strings.ifNotBlank((String)meta.contentType(), propertiesOption::setContentType);
        Strings.ifNotBlank((String)meta.identifier(), propertiesOption::setIdentifier);
    }
}

