/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.writer.exporting;

import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.ExportFieldOption;
import cn.orionsec.kit.office.excel.writer.BaseExcelWriteable;
import cn.orionsec.kit.office.excel.writer.exporting.ExportInitializer;
import cn.orionsec.kit.office.excel.writer.exporting.ExportProcessor;
import cn.orionsec.kit.office.excel.writer.exporting.SheetConfig;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExport<T>
extends BaseExcelWriteable {
    private final Sheet sheet;
    private final SheetConfig<T> sheetConfig;
    private final ExportInitializer<T> initializer;
    private final ExportProcessor<T> processor;
    private int rows;

    public ExcelExport(Class<T> targetClass) {
        this(targetClass, (Workbook)new SXSSFWorkbook(), null);
    }

    public ExcelExport(Class<T> targetClass, Workbook workbook) {
        this(targetClass, workbook, null);
    }

    public ExcelExport(Class<T> targetClass, Sheet sheet) {
        this(targetClass, sheet.getWorkbook(), sheet);
    }

    public ExcelExport(Class<T> targetClass, Workbook workbook, Sheet sheet) {
        super(workbook);
        Valid.notNull(targetClass, (String)"target class is null", (Object[])new Object[0]);
        this.sheetConfig = new SheetConfig();
        this.initializer = new ExportInitializer<T>(workbook, sheet, targetClass, this.sheetConfig);
        this.sheetConfig.initializer = this.initializer;
        this.processor = new ExportProcessor<T>(workbook, this.initializer.sheet, this.sheetConfig);
        this.sheet = this.initializer.sheet;
    }

    public static <T> ExcelExport<T> create(Class<T> targetClass) {
        return new ExcelExport<T>(targetClass).init();
    }

    public static <T> ExcelExport<T> create(Class<T> targetClass, Workbook workbook) {
        return new ExcelExport<T>(targetClass, workbook).init();
    }

    public static <T> ExcelExport<T> create(Class<T> targetClass, Sheet sheet) {
        return new ExcelExport<T>(targetClass, sheet).init();
    }

    public static <T> ExcelExport<T> create(Class<T> targetClass, Workbook workbook, Sheet sheet) {
        return new ExcelExport<T>(targetClass, workbook, sheet).init();
    }

    public ExcelExport<T> init() {
        this.initializer.init();
        return this;
    }

    public ExcelExport<T> skip() {
        ++this.initializer.rowIndex;
        return this;
    }

    public ExcelExport<T> skip(int i) {
        this.initializer.rowIndex += i;
        return this;
    }

    public ExcelExport<T> skipNullRows(boolean skipNullRows) {
        this.sheetConfig.sheetOption.setSkipNullRows(skipNullRows);
        return this;
    }

    public ExcelExport<T> skipTitle() {
        this.sheetConfig.sheetOption.setSkipTitle(true);
        return this;
    }

    public ExcelExport<T> sheet(String sheetName) {
        if (sheetName != null) {
            this.sheetConfig.sheetOption.setName(sheetName);
            this.sheetConfig.sheetOption.setNameReset(true);
        }
        return this;
    }

    public ExcelExport<T> title(String title) {
        if (title != null) {
            this.sheetConfig.sheetOption.setTitle(title);
        }
        return this;
    }

    public ExcelExport<T> protect(String password) {
        this.sheet.protectSheet(password);
        return this;
    }

    public ExcelExport<T> merge(int row, int firstCol, int lastCol) {
        return this.merge(new CellRangeAddress(row, row, firstCol, lastCol), true);
    }

    public ExcelExport<T> merge(int row, int firstCol, int lastCol, boolean mergeBorder) {
        return this.merge(new CellRangeAddress(row, row, firstCol, lastCol), mergeBorder);
    }

    public ExcelExport<T> merge(int firstRow, int lastRow, int firstCol, int lastCol) {
        return this.merge(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol), true);
    }

    public ExcelExport<T> merge(int firstRow, int lastRow, int firstCol, int lastCol, boolean mergeBorder) {
        return this.merge(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol), mergeBorder);
    }

    public ExcelExport<T> merge(CellRangeAddress region, boolean mergeBorder) {
        this.initializer.checkInit();
        Excels.mergeCell(this.sheet, region);
        if (mergeBorder) {
            Optional.ofNullable(Excels.getCell(this.sheet, region.getFirstRow(), 0)).map(Cell::getCellStyle).ifPresent(s -> Excels.mergeCellBorder(this.sheet, s.getBorderTop().getCode(), s.getTopBorderColor(), region));
        }
        return this;
    }

    public ExcelExport<T> headers(String ... headers) {
        this.initializer.checkInit();
        this.initializer.headers(false, headers);
        return this;
    }

    public ExcelExport<T> addRow(T row) {
        return this.addRows(Lists.singleton(row));
    }

    public ExcelExport<T> addRows(Collection<T> rows) {
        this.initializer.checkInit();
        Integer rowHeight = this.sheetConfig.sheetOption.getRowHeight();
        for (T row : rows) {
            ++this.rows;
            if (row == null && this.sheetConfig.sheetOption.isSkipNullRows()) continue;
            Row dataRow = this.sheet.createRow(this.initializer.rowIndex);
            if (rowHeight != null) {
                dataRow.setHeightInPoints((float)rowHeight.intValue());
            }
            this.sheetConfig.fieldOptions.forEach((col, option) -> this.processor.setCellValue(dataRow.createCell(col.intValue()), this.initializer.rowIndex, (int)col, row, (ExportFieldOption)option));
            ++this.initializer.rowIndex;
        }
        return this;
    }

    @Override
    protected BaseExcelWriteable write(OutputStream out, String password, boolean close) {
        this.initializer.checkInit();
        this.initializer.finished();
        return super.write(out, password, close);
    }

    public CellStyle createCellStyle() {
        return this.workbook.createCellStyle();
    }

    public CellStyle cloneCellStyle(int column) {
        CellStyle style = this.workbook.createCellStyle();
        CellStyle columnStyle = this.sheetConfig.getColumnStyles().get(column);
        if (columnStyle != null) {
            style.cloneStyleFrom(columnStyle);
        }
        return style;
    }

    public Font createFont() {
        return this.workbook.createFont();
    }

    public DataFormat createFormat() {
        return this.workbook.createDataFormat();
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public SheetConfig<T> getSheetConfig() {
        return this.sheetConfig;
    }

    public int getLines() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getColumnMaxIndex() {
        return this.sheetConfig.sheetOption.getColumnMaxIndex();
    }

    public int getRowIndex() {
        return this.initializer.rowIndex;
    }

    public int getRows() {
        return this.rows;
    }
}

