/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.writer;

import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.PropertiesOption;
import cn.orionsec.kit.office.excel.writer.BaseExcelWriteable;
import cn.orionsec.kit.office.excel.writer.ExcelArrayWriter;
import cn.orionsec.kit.office.excel.writer.ExcelBeanWriter;
import cn.orionsec.kit.office.excel.writer.ExcelLambdaWriter;
import cn.orionsec.kit.office.excel.writer.ExcelMapWriter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelWriterBuilder
extends BaseExcelWriteable {
    public ExcelWriterBuilder() {
        this((Workbook)new SXSSFWorkbook());
    }

    public ExcelWriterBuilder(Workbook workbook) {
        super(workbook);
    }

    public static ExcelWriterBuilder create() {
        return new ExcelWriterBuilder();
    }

    public static ExcelWriterBuilder create(Workbook workbook) {
        return new ExcelWriterBuilder(workbook);
    }

    public <T> ExcelArrayWriter<T> getArrayWriter(String name) {
        return new ExcelArrayWriter(this.workbook, this.workbook.getSheet(name));
    }

    public <T> ExcelArrayWriter<T> getArrayWriter(int index) {
        return new ExcelArrayWriter(this.workbook, this.workbook.getSheetAt(index));
    }

    public <K, V> ExcelMapWriter<K, V> getMapWriter(String name) {
        return new ExcelMapWriter(this.workbook, this.workbook.getSheet(name));
    }

    public <K, V> ExcelMapWriter<K, V> getMapWriter(int index) {
        return new ExcelMapWriter(this.workbook, this.workbook.getSheetAt(index));
    }

    public <T> ExcelBeanWriter<T> getBeanWriter(String name, Class<T> targetClass) {
        return new ExcelBeanWriter<T>(this.workbook, this.workbook.getSheet(name), targetClass);
    }

    public <T> ExcelBeanWriter<T> getBeanWriter(int index, Class<T> targetClass) {
        return new ExcelBeanWriter<T>(this.workbook, this.workbook.getSheetAt(index), targetClass);
    }

    public <T> ExcelLambdaWriter<T> getLambdaWriter(String name) {
        return new ExcelLambdaWriter(this.workbook, this.workbook.getSheet(name));
    }

    public <T> ExcelLambdaWriter<T> getLambdaWriter(int index) {
        return new ExcelLambdaWriter(this.workbook, this.workbook.getSheetAt(index));
    }

    public <T> ExcelArrayWriter<T> createArrayWriter() {
        return new ExcelArrayWriter(this.workbook, this.workbook.createSheet());
    }

    public <T> ExcelArrayWriter<T> createArrayWriter(String name) {
        return new ExcelArrayWriter(this.workbook, this.workbook.createSheet(name));
    }

    public <K, V> ExcelMapWriter<K, V> createMapWriter() {
        return new ExcelMapWriter(this.workbook, this.workbook.createSheet());
    }

    public <K, V> ExcelMapWriter<K, V> createMapWriter(String name) {
        return new ExcelMapWriter(this.workbook, this.workbook.createSheet(name));
    }

    public <T> ExcelBeanWriter<T> createBeanWriter(Class<T> targetClass) {
        return new ExcelBeanWriter<T>(this.workbook, this.workbook.createSheet(), targetClass);
    }

    public <T> ExcelBeanWriter<T> createBeanWriter(String name, Class<T> targetClass) {
        return new ExcelBeanWriter<T>(this.workbook, this.workbook.createSheet(name), targetClass);
    }

    public <T> ExcelLambdaWriter<T> createLambdaWriter() {
        return new ExcelLambdaWriter(this.workbook, this.workbook.createSheet());
    }

    public <T> ExcelLambdaWriter<T> createLambdaWriter(String name) {
        return new ExcelLambdaWriter(this.workbook, this.workbook.createSheet(name));
    }

    public ExcelWriterBuilder properties(PropertiesOption option) {
        Excels.setProperties(this.workbook, option);
        return this;
    }
}

