/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.writer;

import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import cn.orionsec.kit.office.excel.option.WriteFieldOption;
import cn.orionsec.kit.office.excel.writer.BaseExcelWriter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelBeanWriter<T>
extends BaseExcelWriter<String, T> {
    private final Class<T> targetClass;
    private final Map<String, Method> getters;

    public ExcelBeanWriter(Workbook workbook, Sheet sheet, Class<T> targetClass) {
        super(workbook, sheet);
        this.targetClass = (Class)Valid.notNull(targetClass, (String)"target class is null", (Object[])new Object[0]);
        this.getters = Methods.getGetterMethodsByCache(targetClass).stream().collect(Collectors.toMap(Fields::getFieldNameByMethod, Function.identity()));
    }

    @Override
    protected void addOption(String field, WriteFieldOption option, Object defaultValue) {
        Valid.notNull((Object)this.getters.get(field), (String)"not found getter method ({}) in {}", (Object[])new Object[]{field, this.targetClass});
        super.addOption(field, option, defaultValue);
    }

    @Override
    protected Object getValue(T row, String key) {
        return Methods.invokeMethod(row, (Method)this.getters.get(key));
    }
}

