/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.writer;

import cn.orionsec.kit.lang.function.select.Selector;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.FooterOption;
import cn.orionsec.kit.office.excel.option.HeaderOption;
import cn.orionsec.kit.office.excel.option.PrintOption;
import cn.orionsec.kit.office.excel.option.WriteFieldOption;
import cn.orionsec.kit.office.excel.type.ExcelFieldType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class BaseExcelWriter<K, V> {
    protected Workbook workbook;
    protected Sheet sheet;
    protected int rowIndex;
    protected int columnMaxIndex;
    protected boolean skipNullRows;
    protected boolean trim;
    protected boolean columnUseDefaultStyle;
    protected boolean headerUseRowStyle;
    protected int titleHeight;
    protected int headerHeight;
    protected int rowHeight;
    protected Map<K, WriteFieldOption> options;
    protected CellStyle titleStyle;
    protected Map<Integer, CellStyle> headerStyles;
    protected Map<Integer, CellStyle> columnStyles;
    protected Map<Integer, Function<V, Selector<V, CellStyle>>> columnStyleSelector;
    private final Map<K, Object> defaultValue;

    public BaseExcelWriter(Workbook workbook, Sheet sheet) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.skipNullRows = true;
        this.options = new LinkedHashMap<K, WriteFieldOption>();
        this.headerStyles = new TreeMap<Integer, CellStyle>();
        this.columnStyles = new TreeMap<Integer, CellStyle>();
        this.columnStyleSelector = new TreeMap<Integer, Function<V, Selector<V, CellStyle>>>();
        this.defaultValue = new HashMap<K, Object>();
    }

    public BaseExcelWriter<K, V> title(String title) {
        return this.title(title, 1, this.columnMaxIndex);
    }

    public BaseExcelWriter<K, V> title(String title, int row) {
        return this.title(title, row, this.columnMaxIndex);
    }

    public BaseExcelWriter<K, V> title(String title, int row, int lastColumnIndex) {
        Valid.gt((Comparable)Integer.valueOf(row), (Comparable)Integer.valueOf(0), (String)"title use row must > 0", (Object[])new Object[0]);
        Valid.gte((Comparable)Integer.valueOf(lastColumnIndex), (Comparable)Integer.valueOf(0), (String)"title last column index row must >= 0", (Object[])new Object[0]);
        Row titleRow = this.sheet.createRow(this.rowIndex++);
        if (this.titleHeight != 0) {
            titleRow.setHeightInPoints((float)this.titleHeight);
        }
        for (int i = 0; i < row - 1; ++i) {
            Row ignoreRow = this.sheet.createRow(this.rowIndex++);
            if (this.titleHeight == 0) continue;
            ignoreRow.setHeightInPoints((float)this.titleHeight);
        }
        Cell cell = titleRow.createCell(0);
        if (this.titleStyle == null) {
            this.titleStyle = this.workbook.createCellStyle();
            this.titleStyle.setAlignment(HorizontalAlignment.CENTER);
            this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        cell.setCellStyle(this.titleStyle);
        if (this.trim) {
            title = title.trim();
        }
        cell.setCellValue(title);
        this.merge(this.rowIndex - row, this.rowIndex - 1, 0, lastColumnIndex, true);
        return this;
    }

    public BaseExcelWriter<K, V> headers(String ... headers) {
        if (Arrays1.isEmpty((Object[])headers)) {
            return this;
        }
        Row row = this.sheet.createRow(this.rowIndex++);
        if (this.headerHeight != 0) {
            row.setHeightInPoints((float)this.headerHeight);
        }
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            if (this.headerUseRowStyle) {
                Optional.ofNullable(this.headerStyles.get(i)).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
            }
            if (this.trim) {
                cell.setCellValue(headers[i].trim());
                continue;
            }
            cell.setCellValue(headers[i]);
        }
        return this;
    }

    public BaseExcelWriter<K, V> skip() {
        ++this.rowIndex;
        return this;
    }

    public BaseExcelWriter<K, V> skip(int i) {
        this.rowIndex += i;
        return this;
    }

    public BaseExcelWriter<K, V> skipNullRows(boolean skip) {
        this.skipNullRows = skip;
        return this;
    }

    public BaseExcelWriter<K, V> trim() {
        this.trim = true;
        return this;
    }

    public BaseExcelWriter<K, V> width(int column, int width) {
        this.sheet.setColumnWidth(column, Excels.getWidth(width));
        return this;
    }

    public BaseExcelWriter<K, V> width(int width) {
        this.sheet.setDefaultColumnWidth(width);
        return this;
    }

    public BaseExcelWriter<K, V> height(int height) {
        this.rowHeight = height;
        this.sheet.setDefaultRowHeightInPoints((float)this.rowHeight);
        this.titleHeight = height;
        this.headerHeight = (short)height;
        return this;
    }

    public BaseExcelWriter<K, V> rowHeight(int height) {
        this.rowHeight = height;
        this.sheet.setDefaultRowHeightInPoints((float)this.rowHeight);
        return this;
    }

    public BaseExcelWriter<K, V> titleHeight(int height) {
        this.titleHeight = height;
        return this;
    }

    public BaseExcelWriter<K, V> headerHeight(int height) {
        this.headerHeight = (short)height;
        return this;
    }

    public BaseExcelWriter<K, V> columnUseDefaultStyle() {
        this.columnUseDefaultStyle = true;
        return this;
    }

    public BaseExcelWriter<K, V> headerUseRowStyle() {
        this.headerUseRowStyle = true;
        return this;
    }

    public BaseExcelWriter<K, V> style(int column, CellStyle style) {
        if (this.headerUseRowStyle && !this.headerStyles.containsKey(column)) {
            this.headerStyles.put(column, style);
        }
        this.columnStyles.put(column, style);
        if (this.columnUseDefaultStyle) {
            this.sheet.setDefaultColumnStyle(column, style);
        }
        return this;
    }

    public BaseExcelWriter<K, V> style(int column, Function<V, Selector<V, CellStyle>> selector) {
        this.columnStyleSelector.put(column, selector);
        return this;
    }

    public BaseExcelWriter<K, V> headerStyle(int column, CellStyle style) {
        this.headerStyles.put(column, style);
        return this;
    }

    public BaseExcelWriter<K, V> titleStyle(CellStyle style) {
        this.titleStyle = style;
        return this;
    }

    public BaseExcelWriter<K, V> selected() {
        this.workbook.setActiveSheet(this.workbook.getSheetIndex(this.sheet));
        return this;
    }

    public BaseExcelWriter<K, V> hidden() {
        this.workbook.setSheetHidden(this.workbook.getSheetIndex(this.sheet), true);
        return this;
    }

    public BaseExcelWriter<K, V> hidden(int column) {
        this.sheet.setColumnHidden(column, true);
        return this;
    }

    public BaseExcelWriter<K, V> filter() {
        return this.filter(0, this.columnMaxIndex);
    }

    public BaseExcelWriter<K, V> filter(int rowIndex) {
        return this.filter(rowIndex, this.columnMaxIndex);
    }

    public BaseExcelWriter<K, V> filter(int rowIndex, int lastColumn) {
        Excels.filterRow(this.sheet, rowIndex, lastColumn);
        return this;
    }

    public BaseExcelWriter<K, V> freeze() {
        return this.freeze(0);
    }

    public BaseExcelWriter<K, V> freeze(int row) {
        Excels.freezeRow(this.sheet, row);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k) {
        this.addOption(k, new WriteFieldOption(column), null);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k, Object defaultValue) {
        this.addOption(k, new WriteFieldOption(column), defaultValue);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k, ExcelFieldType type) {
        this.addOption(k, new WriteFieldOption(column, type), null);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k, ExcelFieldType type, Object defaultValue) {
        this.addOption(k, new WriteFieldOption(column, type), defaultValue);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k, ExcelFieldType type, String format) {
        this.addOption(k, new WriteFieldOption(column, type, format), null);
        return this;
    }

    public BaseExcelWriter<K, V> option(int column, K k, ExcelFieldType type, String format, Object defaultValue) {
        this.addOption(k, new WriteFieldOption(column, type, format), defaultValue);
        return this;
    }

    public BaseExcelWriter<K, V> option(K k, WriteFieldOption option) {
        this.addOption(k, option, null);
        return this;
    }

    public BaseExcelWriter<K, V> option(K k, WriteFieldOption option, Object defaultValue) {
        this.addOption(k, option, defaultValue);
        return this;
    }

    protected void addOption(K k, WriteFieldOption option, Object defaultValue) {
        Valid.gte((Comparable)Integer.valueOf(option.getIndex()), (Comparable)Integer.valueOf(0), (String)"title use row must >= 0", (Object[])new Object[0]);
        this.options.put(k, option);
        this.columnMaxIndex = Math.max(this.columnMaxIndex, option.getIndex());
        if (defaultValue != null) {
            this.defaultValue.put(k, defaultValue);
        }
    }

    public BaseExcelWriter<K, V> defaultValue(K k, Object value) {
        this.defaultValue.put(k, value);
        return this;
    }

    public BaseExcelWriter<K, V> merge(int row, int firstCol, int lastCol) {
        return this.merge(new CellRangeAddress(row, row, firstCol, lastCol), true);
    }

    public BaseExcelWriter<K, V> merge(int row, int firstCol, int lastCol, boolean mergeBorder) {
        return this.merge(new CellRangeAddress(row, row, firstCol, lastCol), mergeBorder);
    }

    public BaseExcelWriter<K, V> merge(int firstRow, int lastRow, int firstCol, int lastCol) {
        return this.merge(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol), true);
    }

    public BaseExcelWriter<K, V> merge(int firstRow, int lastRow, int firstCol, int lastCol, boolean mergeBorder) {
        return this.merge(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol), mergeBorder);
    }

    public BaseExcelWriter<K, V> merge(CellRangeAddress region, boolean mergeBorder) {
        Excels.mergeCell(this.sheet, region);
        if (mergeBorder) {
            Optional.ofNullable(Excels.getCell(this.sheet, region.getFirstRow(), 0)).map(Cell::getCellStyle).ifPresent(s -> Excels.mergeCellBorder(this.sheet, s.getBorderTop().getCode(), s.getTopBorderColor(), region));
        }
        return this;
    }

    public BaseExcelWriter<K, V> addRows(Collection<V> list) {
        list.forEach(this::addRow);
        return this;
    }

    public BaseExcelWriter<K, V> addRow(V row) {
        if (row == null && this.skipNullRows) {
            return this;
        }
        Row r = this.sheet.createRow(this.rowIndex++);
        if (this.rowHeight != 0) {
            r.setHeightInPoints((float)this.rowHeight);
        }
        if (row == null) {
            return this;
        }
        this.options.forEach((k, option) -> {
            if (option == null) {
                return;
            }
            int columnIndex = option.getIndex();
            Cell cell = r.createCell(columnIndex);
            CellStyle cellStyle = Optional.ofNullable(this.columnStyleSelector.get(columnIndex)).map(s -> (Selector)s.apply(row)).map(s -> (CellStyle)s.orElse(null)).orElse(this.columnStyles.get(columnIndex));
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            Object value = Objects1.def((Object)this.getValue(row, k), () -> this.defaultValue.get(k));
            if (this.trim && value instanceof String) {
                value = ((String)value).trim();
            }
            Excels.setCellValue(cell, value, option.getType(), option.getCellOption());
        });
        return this;
    }

    public BaseExcelWriter<K, V> header(HeaderOption option) {
        Excels.setHeader(this.sheet, option);
        return this;
    }

    public BaseExcelWriter<K, V> footer(FooterOption option) {
        Excels.setFooter(this.sheet, option);
        return this;
    }

    public BaseExcelWriter<K, V> print(PrintOption option) {
        Excels.parsePrint(this.sheet, option);
        return this;
    }

    public BaseExcelWriter<K, V> protect(String password) {
        this.sheet.protectSheet(password);
        return this;
    }

    public BaseExcelWriter<K, V> displayGridLines() {
        this.sheet.setDisplayGridlines(false);
        return this;
    }

    public BaseExcelWriter<K, V> displayRowColHeadings() {
        this.sheet.setDisplayRowColHeadings(false);
        return this;
    }

    public BaseExcelWriter<K, V> displayFormulas() {
        this.sheet.setDisplayFormulas(true);
        return this;
    }

    protected abstract Object getValue(V var1, K var2);

    public CellStyle createCellStyle() {
        return this.workbook.createCellStyle();
    }

    public Font createFont() {
        return this.workbook.createFont();
    }

    public DataFormat createFormat() {
        return this.workbook.createDataFormat();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public int getLines() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getColumnMaxIndex() {
        return this.columnMaxIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }
}

