/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.style;

import cn.orionsec.kit.lang.utils.Colors;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.FontOption;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontScheme;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FontStream {
    private final Workbook workbook;
    private final Font font;

    public FontStream(Workbook workbook) {
        this.workbook = workbook;
        this.font = workbook.createFont();
    }

    public FontStream(Workbook workbook, Font font) {
        this.workbook = workbook;
        this.font = font;
    }

    public static FontStream fontStream(Workbook workbook) {
        return new FontStream(workbook);
    }

    public static FontStream fontStream(Workbook workbook, Font font) {
        return new FontStream(workbook, font);
    }

    public static Font parseFont(Workbook workbook, FontOption option) {
        String fontColor;
        Integer fontSize;
        if (option == null) {
            return null;
        }
        FontStream stream = new FontStream(workbook);
        String fontName = option.getFontName();
        if (fontName != null) {
            stream.name(fontName);
        }
        if ((fontSize = option.getFontSize()) != null) {
            stream.size(fontSize.shortValue());
        }
        if ((fontColor = option.getColor()) != null) {
            if (workbook instanceof XSSFWorkbook || workbook instanceof SXSSFWorkbook) {
                stream.color(fontColor);
            } else if (workbook instanceof HSSFWorkbook) {
                short paletteColorIndex = option.getPaletteColorIndex();
                short usePaletteColorIndex = Excels.paletteColor(workbook, paletteColorIndex, Colors.toRgb((String)fontColor));
                stream.color(usePaletteColorIndex);
                if (paletteColorIndex == usePaletteColorIndex) {
                    paletteColorIndex = (short)(paletteColorIndex + 1);
                    option.setPaletteColorIndex(paletteColorIndex);
                }
            }
        }
        return stream.bold(option.isBold()).italic(option.isItalic()).deleteLine(option.isDelete()).underLine(option.getUnder().getCode()).getFont();
    }

    public FontStream name(String name) {
        this.font.setFontName(name);
        return this;
    }

    public FontStream size(int size) {
        this.font.setFontHeightInPoints((short)size);
        return this;
    }

    public FontStream deleteLine() {
        this.font.setStrikeout(true);
        return this;
    }

    public FontStream unsetDeleteLine() {
        this.font.setStrikeout(false);
        return this;
    }

    public FontStream deleteLine(boolean set) {
        this.font.setStrikeout(set);
        return this;
    }

    public FontStream underLine() {
        this.font.setUnderline((byte)1);
        return this;
    }

    public FontStream unsetUnderLine() {
        this.font.setUnderline((byte)0);
        return this;
    }

    public FontStream underLine(int line) {
        this.font.setUnderline((byte)line);
        return this;
    }

    public FontStream underDoubleLine() {
        this.font.setUnderline((byte)2);
        return this;
    }

    public FontStream italic() {
        this.font.setItalic(true);
        return this;
    }

    public FontStream unsetItalic() {
        this.font.setItalic(false);
        return this;
    }

    public FontStream italic(boolean set) {
        this.font.setItalic(set);
        return this;
    }

    public FontStream bold() {
        this.font.setBold(true);
        return this;
    }

    public FontStream unsetBold() {
        this.font.setBold(false);
        return this;
    }

    public FontStream bold(boolean set) {
        this.font.setBold(set);
        return this;
    }

    public FontStream typeOffset(int offset) {
        this.font.setTypeOffset((short)offset);
        return this;
    }

    public FontStream unsetOffset() {
        this.font.setTypeOffset((short)0);
        return this;
    }

    public FontStream topOffset() {
        this.font.setTypeOffset((short)1);
        return this;
    }

    public FontStream bottomOffset() {
        this.font.setTypeOffset((short)2);
        return this;
    }

    public FontStream charset(int charset) {
        this.font.setCharSet(charset);
        return this;
    }

    public FontStream ansiCharset() {
        this.font.setCharSet(0);
        return this;
    }

    public FontStream defaultCharset() {
        this.font.setCharSet(1);
        return this;
    }

    public FontStream symbolCharset() {
        this.font.setCharSet(2);
        return this;
    }

    public FontStream color(int c) {
        this.font.setColor((short)c);
        return this;
    }

    public FontStream color(byte[] c) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setColor(new XSSFColor(c, null));
        }
        return this;
    }

    public FontStream color(short index, byte[] c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.font.setColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public FontStream color(String c) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public FontStream color(short index, String c) {
        return this.color(index, Colors.toRgb((String)c));
    }

    public FontStream blue() {
        this.font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        return this;
    }

    public FontStream black() {
        this.font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        return this;
    }

    public FontStream red() {
        this.font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        return this;
    }

    public FontStream pink() {
        this.font.setColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
        return this;
    }

    public FontStream indigo() {
        this.font.setColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
        return this;
    }

    public FontStream family(int i) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setFamily(i);
        }
        return this;
    }

    public FontStream unsetFamily() {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setFamily(0);
        }
        return this;
    }

    public FontStream scheme(int i) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setScheme(FontScheme.valueOf((int)i));
        }
        return this;
    }

    public FontStream unsetScheme() {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setScheme(FontScheme.NONE);
        }
        return this;
    }

    public FontStream themesTable(ThemesTable table) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setThemesTable(table);
        }
        return this;
    }

    public FontStream themesColor(int i) {
        if (this.font instanceof XSSFFont) {
            ((XSSFFont)this.font).setThemeColor((short)i);
        }
        return this;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.font.getFontHeightInPoints();
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public boolean isBold() {
        return this.font.getBold();
    }

    public boolean isItalic() {
        return this.font.getItalic();
    }

    public boolean isDelete() {
        return this.font.getStrikeout();
    }

    public byte getUnderLineType() {
        return this.font.getUnderline();
    }

    public int getCharset() {
        return this.font.getCharSet();
    }

    public short getOffsetType() {
        return this.font.getTypeOffset();
    }

    public short getColor() {
        return this.font.getColor();
    }

    public int getFamily() {
        if (this.font instanceof XSSFFont) {
            return ((XSSFFont)this.font).getFamily();
        }
        return -1;
    }

    public int getScheme() {
        if (this.font instanceof XSSFFont) {
            return ((XSSFFont)this.font).getScheme().getValue();
        }
        return -1;
    }

    public int getThemeColor() {
        if (this.font instanceof XSSFFont) {
            return ((XSSFFont)this.font).getThemeColor();
        }
        return -1;
    }
}

